/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Frame;
import flash.swf.Header;
import flash.swf.Movie;
import flash.swf.Tag;
import flash.swf.TagHandler;
import flash.swf.tags.DebugID;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.DoAction;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.ImportAssets;
import flash.swf.tags.ShowFrame;
import flash.swf.tags.SymbolClass;
import flash.swf.types.ActionList;
import flash.swf.types.ImportRecord;
import java.util.HashSet;
import java.util.Iterator;

public class MovieEncoder {
    private TagHandler handler;
    private HashSet done;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MovieEncoder(TagHandler handler) {
        this.handler = handler;
        this.done = new HashSet();
    }

    public void export(Movie m) {
        Header h = new Header();
        h.version = m.version;
        h.compressed = Header.useCompression(m.version);
        h.size = m.size;
        h.rate = m.framerate;
        this.handler.header(h);
        if (m.fileAttributes != null) {
            if (m.metadata != null) {
                m.fileAttributes.hasMetadata = true;
            }
            m.fileAttributes.visit(this.handler);
        }
        if (m.metadata != null) {
            m.metadata.visit(this.handler);
        }
        if (m.enableDebugger != null) {
            m.enableDebugger.visit(this.handler);
        }
        if (m.uuid != null) {
            new DebugID(m.uuid).visit(this.handler);
        }
        if (m.protect != null) {
            m.protect.visit(this.handler);
        }
        if (m.scriptLimits != null) {
            m.scriptLimits.visit(this.handler);
        }
        if (m.bgcolor != null) {
            m.bgcolor.visit(this.handler);
        }
        if (m.productInfo != null) {
            m.productInfo.visit(this.handler);
        }
        if (m.sceneAndFrameLabelData != null) {
            m.sceneAndFrameLabelData.visit(this.handler);
        }
        boolean associateRootClass = m.topLevelClass != null;
        Iterator i = m.frames.iterator();
        while (i.hasNext()) {
            Tag tag;
            Tag tag2;
            Iterator j;
            Iterator j2;
            Frame frame = (Frame)i.next();
            if (frame.label != null) {
                frame.label.visit(this.handler);
            }
            if (!frame.imports.isEmpty()) {
                j2 = frame.imports.iterator();
                while (j2.hasNext()) {
                    ImportAssets importAssets = (ImportAssets)j2.next();
                    importAssets.visit(this.handler);
                }
            }
            j2 = frame.getReferences();
            while (j2.hasNext()) {
                DefineTag ref = (DefineTag)j2.next();
                this.define(ref);
            }
            if (frame.hasExports()) {
                ExportAssets exportAssets = new ExportAssets();
                j = frame.exportIterator();
                while (j.hasNext()) {
                    tag2 = (DefineTag)j.next();
                    exportAssets.exports.add(tag2);
                }
                exportAssets.visit(this.handler);
            }
            if (frame.hasFonts()) {
                Iterator k = frame.fontsIterator();
                while (k.hasNext()) {
                    tag = (DefineFont)k.next();
                    if (this.done.contains(tag)) continue;
                    ((DefineFont)tag).visit(this.handler);
                    this.done.add(tag);
                }
            }
            j2 = frame.doABCs.iterator();
            while (j2.hasNext()) {
                tag = (Tag)j2.next();
                tag.visit(this.handler);
            }
            SymbolClass classes = new SymbolClass();
            if (frame.hasSymbolClasses()) {
                classes.class2tag.putAll(frame.symbolClass.class2tag);
            }
            if (associateRootClass) {
                classes.topLevelClass = m.topLevelClass;
            }
            if (associateRootClass || frame.hasSymbolClasses()) {
                classes.visit(this.handler);
            }
            associateRootClass = false;
            j = frame.controlTags.iterator();
            while (j.hasNext()) {
                tag2 = (Tag)j.next();
                tag2.visit(this.handler);
            }
            j = frame.doActions.iterator();
            while (j.hasNext()) {
                ActionList list = (ActionList)j.next();
                new DoAction(list).visit(this.handler);
            }
            new ShowFrame().visit(this.handler);
        }
        this.handler.finish();
    }

    public void define(Tag tag) {
        if (!this.done.contains(tag)) {
            Iterator i = tag.getReferences();
            while (i.hasNext()) {
                Tag ref = (Tag)i.next();
                this.define(ref);
            }
            if (!(tag instanceof ImportRecord)) {
                tag.visit(this.handler);
                Tag visitAfter = null;
                if (tag instanceof DefineSprite) {
                    visitAfter = ((DefineSprite)tag).scalingGrid;
                } else if (tag instanceof DefineButton) {
                    visitAfter = ((DefineButton)tag).scalingGrid;
                } else if (tag instanceof DefineShape) {
                    visitAfter = ((DefineShape)tag).scalingGrid;
                } else if (tag instanceof DefineFont) {
                    visitAfter = ((DefineFont)tag).zones;
                } else if (tag instanceof DefineEditText) {
                    visitAfter = ((DefineEditText)tag).csmTextSettings;
                } else if (tag instanceof DefineText) {
                    visitAfter = ((DefineText)tag).csmTextSettings;
                }
                this.visitAfter(visitAfter);
                visitAfter = null;
                if (tag instanceof DefineFont) {
                    visitAfter = ((DefineFont)tag).license;
                }
                this.visitAfter(visitAfter);
            }
            this.done.add(tag);
        }
    }

    private void visitAfter(Tag visitAfter) {
        if (visitAfter != null) {
            if (!$assertionsDisabled && this.done.contains(visitAfter)) {
                throw new AssertionError();
            }
            visitAfter.visit(this.handler);
            this.done.add(visitAfter);
        }
    }

    static {
        $assertionsDisabled = !MovieEncoder.class.desiredAssertionStatus();
    }
}

