/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DocumentJarClassLoader;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.Messages;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.EventListenerInitializer;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BaseScriptingEnvironment {
    public static final String INLINE_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.inline.script.description";
    public static final String EVENT_SCRIPT_DESCRIPTION = "BaseScriptingEnvironment.constant.event.script.description";
    protected static final String EVENT_NAME = "event";
    protected static final String ALTERNATE_EVENT_NAME = "evt";
    protected BridgeContext bridgeContext;
    protected UserAgent userAgent;
    protected Document document;
    protected ParsedURL docPURL;
    protected Set languages = new HashSet();
    protected Interpreter interpreter;

    public static boolean isDynamicDocument(BridgeContext ctx, Document doc) {
        Element elt = doc.getDocumentElement();
        if (elt != null && "http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            if (elt.getAttributeNS(null, "onabort").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onresize").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onunload").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onscroll").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onzoom").length() > 0) {
                return true;
            }
            return BaseScriptingEnvironment.isDynamicElement(ctx, doc.getDocumentElement());
        }
        return false;
    }

    public static boolean isDynamicElement(BridgeContext ctx, Element elt) {
        List bridgeExtensions = ctx.getBridgeExtensions(elt.getOwnerDocument());
        return BaseScriptingEnvironment.isDynamicElement(elt, ctx, bridgeExtensions);
    }

    public static boolean isDynamicElement(Element elt, BridgeContext ctx, List bridgeExtensions) {
        Iterator i = bridgeExtensions.iterator();
        while (i.hasNext()) {
            BridgeExtension bridgeExtension = (BridgeExtension)i.next();
            if (!bridgeExtension.isDynamicElement(elt)) continue;
            return true;
        }
        if ("http://www.w3.org/2000/svg".equals(elt.getNamespaceURI())) {
            if (elt.getAttributeNS(null, "onkeyup").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeydown").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onkeypress").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onload").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onerror").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onactivate").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onclick").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onfocusin").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onfocusout").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmousedown").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmousemove").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseout").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseover").length() > 0) {
                return true;
            }
            if (elt.getAttributeNS(null, "onmouseup").length() > 0) {
                return true;
            }
        }
        for (Node n = elt.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 || !BaseScriptingEnvironment.isDynamicElement(ctx, (Element)n)) continue;
            return true;
        }
        return false;
    }

    public BaseScriptingEnvironment(BridgeContext ctx) {
        this.bridgeContext = ctx;
        this.document = ctx.getDocument();
        this.docPURL = new ParsedURL(((SVGDocument)this.document).getURL());
        this.userAgent = this.bridgeContext.getUserAgent();
    }

    public org.apache.batik.script.Window createWindow(Interpreter interp, String lang) {
        return new Window(interp, lang);
    }

    public org.apache.batik.script.Window createWindow() {
        return this.createWindow(null, null);
    }

    public Interpreter getInterpreter() {
        if (this.interpreter != null) {
            return this.interpreter;
        }
        SVGSVGElement root = (SVGSVGElement)this.document.getDocumentElement();
        String lang = root.getContentScriptType();
        return this.getInterpreter(lang);
    }

    public Interpreter getInterpreter(String lang) {
        this.interpreter = this.bridgeContext.getInterpreter(lang);
        if (this.interpreter == null) {
            if (this.languages.contains(lang)) {
                return null;
            }
            this.languages.add(lang);
            return null;
        }
        if (!this.languages.contains(lang)) {
            this.languages.add(lang);
            this.initializeEnvironment(this.interpreter, lang);
        }
        return this.interpreter;
    }

    public void initializeEnvironment(Interpreter interp, String lang) {
        interp.bindObject("window", (Object)this.createWindow(interp, lang));
    }

    public void loadScripts() {
        org.apache.batik.script.Window window = null;
        NodeList scripts = this.document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "script");
        int len = scripts.getLength();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            Element script = (Element)scripts.item(i);
            String type = script.getAttributeNS(null, "type");
            if (type.length() == 0) {
                type = "text/ecmascript";
            }
            if (type.equals("application/java-archive")) {
                try {
                    String href = XLinkSupport.getXLinkHref((Element)script);
                    ParsedURL purl = new ParsedURL(XMLBaseSupport.getCascadedXMLBase((Element)script), href);
                    this.checkCompatibleScriptURL(type, purl);
                    URL docURL = null;
                    try {
                        docURL = new URL(this.docPURL.toString());
                    }
                    catch (MalformedURLException mue) {
                        // empty catch block
                    }
                    DocumentJarClassLoader cll = new DocumentJarClassLoader(new URL(purl.toString()), docURL);
                    URL url = cll.findResource("META-INF/MANIFEST.MF");
                    if (url == null) continue;
                    Manifest man = new Manifest(url.openStream());
                    String sh = man.getMainAttributes().getValue("Script-Handler");
                    if (sh != null) {
                        ScriptHandler h = (ScriptHandler)cll.loadClass(sh).newInstance();
                        if (window == null) {
                            window = this.createWindow();
                        }
                        h.run(this.document, window);
                    }
                    if ((sh = man.getMainAttributes().getValue("SVG-Handler-Class")) == null) continue;
                    EventListenerInitializer initializer = (EventListenerInitializer)cll.loadClass(sh).newInstance();
                    if (window == null) {
                        window = this.createWindow();
                    }
                    initializer.initializeEventListeners((SVGDocument)this.document);
                }
                catch (Exception e) {
                    if (this.userAgent == null) continue;
                    this.userAgent.displayError(e);
                }
                continue;
            }
            Interpreter interpreter = this.getInterpreter(type);
            if (interpreter == null) continue;
            try {
                Reader reader;
                String href = XLinkSupport.getXLinkHref((Element)script);
                String desc = null;
                if (href.length() > 0) {
                    desc = href;
                    ParsedURL purl = new ParsedURL(XMLBaseSupport.getCascadedXMLBase((Element)script), href);
                    this.checkCompatibleScriptURL(type, purl);
                    reader = new InputStreamReader(purl.openStream());
                } else {
                    Node n;
                    this.checkCompatibleScriptURL(type, this.docPURL);
                    DocumentLoader dl = this.bridgeContext.getDocumentLoader();
                    Element e = script;
                    SVGDocument d = (SVGDocument)e.getOwnerDocument();
                    int line = dl.getLineNumber(script);
                    desc = Messages.formatMessage(INLINE_SCRIPT_DESCRIPTION, new Object[]{d.getURL(), "<" + script.getNodeName() + ">", new Integer(line)});
                    if (n == null) continue;
                    StringBuffer sb = new StringBuffer();
                    for (n = script.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (n.getNodeType() != 4 && n.getNodeType() != 3) continue;
                        sb.append(n.getNodeValue());
                    }
                    reader = new StringReader(sb.toString());
                }
                interpreter.evaluate(reader, desc);
                continue;
            }
            catch (IOException e) {
                if (this.userAgent != null) {
                    this.userAgent.displayError(e);
                }
                return;
            }
            catch (InterpreterException e) {
                System.err.println("InterpExcept: " + (Object)((Object)e));
                this.handleInterpreterException(e);
                return;
            }
            catch (SecurityException e) {
                if (this.userAgent == null) continue;
                this.userAgent.displayError(e);
            }
        }
    }

    protected void checkCompatibleScriptURL(String scriptType, ParsedURL scriptPURL) {
        this.userAgent.checkLoadScript(scriptType, scriptPURL, this.docPURL);
    }

    public void dispatchSVGLoadEvent() {
        SVGSVGElement root = (SVGSVGElement)this.document.getDocumentElement();
        String lang = root.getContentScriptType();
        this.dispatchSVGLoad((Element)root, true, lang);
    }

    protected void dispatchSVGLoad(Element elt, boolean checkCanRun, String lang) {
        for (Node n = elt.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            this.dispatchSVGLoad((Element)n, checkCanRun, lang);
        }
        DocumentEvent de = (DocumentEvent)((Object)elt.getOwnerDocument());
        Event ev = de.createEvent("SVGEvents");
        ev.initEvent("SVGLoad", false, false);
        EventTarget t = (EventTarget)((Object)elt);
        final String s = elt.getAttributeNS(null, "onload");
        if (s.length() == 0) {
            t.dispatchEvent(ev);
            return;
        }
        final Interpreter interp = this.getInterpreter();
        if (interp == null) {
            t.dispatchEvent(ev);
            return;
        }
        if (checkCanRun) {
            this.checkCompatibleScriptURL(lang, this.docPURL);
            checkCanRun = false;
        }
        DocumentLoader dl = this.bridgeContext.getDocumentLoader();
        SVGDocument d = (SVGDocument)elt.getOwnerDocument();
        int line = dl.getLineNumber(elt);
        final String desc = Messages.formatMessage(EVENT_SCRIPT_DESCRIPTION, new Object[]{d.getURL(), "onload", new Integer(line)});
        EventListener l = new EventListener(){

            public void handleEvent(Event evt) {
                try {
                    interp.bindObject(BaseScriptingEnvironment.EVENT_NAME, (Object)evt);
                    interp.bindObject(BaseScriptingEnvironment.ALTERNATE_EVENT_NAME, (Object)evt);
                    interp.evaluate((Reader)new StringReader(s), desc);
                }
                catch (IOException io) {
                }
                catch (InterpreterException e) {
                    BaseScriptingEnvironment.this.handleInterpreterException(e);
                }
            }
        };
        t.addEventListener("SVGLoad", l, false);
        t.dispatchEvent(ev);
        t.removeEventListener("SVGLoad", l, false);
    }

    protected void dispatchSVGZoomEvent() {
        this.dispatchSVGDocEvent("SVGZoom");
    }

    protected void dispatchSVGScrollEvent() {
        this.dispatchSVGDocEvent("SVGScroll");
    }

    protected void dispatchSVGResizeEvent() {
        this.dispatchSVGDocEvent("SVGResize");
    }

    protected void dispatchSVGDocEvent(String eventType) {
        SVGSVGElement root;
        SVGSVGElement t = root = (SVGSVGElement)this.document.getDocumentElement();
        DocumentEvent de = (DocumentEvent)((Object)this.document);
        Event ev = de.createEvent("SVGEvents");
        ev.initEvent(eventType, false, false);
        t.dispatchEvent(ev);
    }

    protected void handleInterpreterException(InterpreterException ie) {
        if (this.userAgent != null) {
            Exception ex = ie.getException();
            this.userAgent.displayError((Exception)(ex == null ? ie : ex));
        }
    }

    protected void handleSecurityException(SecurityException se) {
        if (this.userAgent != null) {
            this.userAgent.displayError(se);
        }
    }

    protected class Window
    implements org.apache.batik.script.Window {
        protected Interpreter interpreter;
        protected String language;

        public Window(Interpreter interp, String lang) {
            this.interpreter = interp;
            this.language = lang;
        }

        public Object setInterval(String script, long interval) {
            return null;
        }

        public Object setInterval(Runnable r, long interval) {
            return null;
        }

        public void clearInterval(Object interval) {
        }

        public Object setTimeout(String script, long timeout) {
            return null;
        }

        public Object setTimeout(Runnable r, long timeout) {
            return null;
        }

        public void clearTimeout(Object timeout) {
        }

        public Node parseXML(String text, Document doc) {
            return null;
        }

        public void getURL(String uri, Window.URLResponseHandler h) {
            this.getURL(uri, h, "UTF8");
        }

        public void getURL(String uri, Window.URLResponseHandler h, String enc) {
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h) {
            this.postURL(uri, content, h, "text/plain", null);
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType) {
            this.postURL(uri, content, h, mimeType, null);
        }

        public void postURL(String uri, String content, Window.URLResponseHandler h, String mimeType, String fEnc) {
        }

        public void alert(String message) {
        }

        public boolean confirm(String message) {
            return false;
        }

        public String prompt(String message) {
            return null;
        }

        public String prompt(String message, String defVal) {
            return null;
        }

        public BridgeContext getBridgeContext() {
            return BaseScriptingEnvironment.this.bridgeContext;
        }

        public Interpreter getInterpreter() {
            return this.interpreter;
        }
    }
}

