/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.CursorManager;
import org.apache.batik.bridge.SVGGElementBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.dom.events.AbstractEvent;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGAElement;

public class SVGAElementBridge
extends SVGGElementBridge {
    public String getLocalName() {
        return "a";
    }

    public Bridge getInstance() {
        return new SVGAElementBridge();
    }

    public void buildGraphicsNode(BridgeContext ctx, Element e, GraphicsNode node) {
        super.buildGraphicsNode(ctx, e, node);
        if (ctx.isInteractive()) {
            EventTarget target = (EventTarget)((Object)e);
            EventListener l = new AnchorListener(ctx.getUserAgent());
            target.addEventListener("click", l, false);
            ctx.storeEventListener(target, "click", l, false);
            l = new CursorMouseOverListener(ctx.getUserAgent());
            target.addEventListener("mouseover", l, false);
            ctx.storeEventListener(target, "mouseover", l, false);
            l = new CursorMouseOutListener(ctx.getUserAgent());
            target.addEventListener("mouseout", l, false);
            ctx.storeEventListener(target, "mouseout", l, false);
        }
    }

    public boolean isComposite() {
        return true;
    }

    public static class CursorMouseOutListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOutListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            if (AbstractEvent.getEventPreventDefault((Event)evt)) {
                return;
            }
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            if (elt != null) {
                this.userAgent.displayMessage("");
            }
        }
    }

    public static class CursorMouseOverListener
    implements EventListener {
        protected UserAgent userAgent;

        public CursorMouseOverListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            SVGAElement elt;
            if (AbstractEvent.getEventPreventDefault((Event)evt)) {
                return;
            }
            Element target = (Element)((Object)evt.getTarget());
            if (CSSUtilities.isAutoCursor(target)) {
                this.userAgent.setSVGCursor(CursorManager.ANCHOR_CURSOR);
            }
            if ((elt = (SVGAElement)evt.getCurrentTarget()) != null) {
                String href = XLinkSupport.getXLinkHref((Element)elt);
                this.userAgent.displayMessage(href);
            }
        }
    }

    public static class AnchorListener
    implements EventListener {
        protected UserAgent userAgent;

        public AnchorListener(UserAgent ua) {
            this.userAgent = ua;
        }

        public void handleEvent(Event evt) {
            if (AbstractEvent.getEventPreventDefault((Event)evt)) {
                return;
            }
            SVGAElement elt = (SVGAElement)evt.getCurrentTarget();
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.userAgent.setSVGCursor(cursor);
            this.userAgent.openLink(elt);
            evt.stopPropagation();
        }
    }
}

