/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import java.util.Iterator;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.ObjectList;

public class ListNode
extends Node {
    public ObjectList<Node> items = new ObjectList(1);
    public ObjectList<Value> values = new ObjectList(1);

    public ListNode(ListNode listNode, Node node, int n) {
        super(n);
        this.items.add(node);
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public boolean isList() {
        return true;
    }

    public int size() {
        return this.items.size();
    }

    public int pos() {
        return this.items.size() != 0 ? this.items.last().pos() : 0;
    }

    public BitSet getGenBits() {
        BitSet bitSet = null;
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            bitSet = BitSet.reset_set(bitSet, node.getKillBits(), node.getGenBits());
        }
        return bitSet;
    }

    public BitSet getKillBits() {
        BitSet bitSet = null;
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            bitSet = BitSet.reset_set(bitSet, node.getGenBits(), node.getKillBits());
        }
        return bitSet;
    }

    public void voidResult() {
        this.items.last().voidResult();
    }

    public String toString() {
        return "List";
    }

    public boolean isAttribute() {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node.isAttribute()) continue;
            return false;
        }
        return true;
    }

    public boolean isLabel() {
        return this.items.size() == 1 && this.items.last().isLabel();
    }

    public boolean hasAttribute(String string) {
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.items.get(i);
            if (!node.hasAttribute(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isLValue() {
        return this.items.size() == 1 && this.items.at(0).isLValue();
    }

    public boolean isConfigurationName() {
        return this.items.size() == 1 && this.items.at(0).isConfigurationName();
    }
}

