/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class ByteList {
    private byte[] a;
    private int size;

    public ByteList(ByteList byteList) {
        this(byteList.size());
        System.arraycopy(byteList.a, 0, this.a, 0, byteList.size());
    }

    public ByteList() {
        this(10);
    }

    public ByteList(int n) {
        this.a = new byte[n];
        this.size = 0;
    }

    public void add(byte by) {
        this.resize();
        this.a[this.size++] = by;
    }

    public void push_back(byte by) {
        this.resize();
        this.a[this.size++] = by;
    }

    public void addAll(byte[] byArray) {
        this.addAll(byArray, byArray.length);
    }

    public void addAll(ByteList byteList) {
        this.addAll(byteList.a, byteList.size);
    }

    private void addAll(byte[] byArray, int n) {
        this.resize(this.size + n);
        System.arraycopy(byArray, 0, this.a, this.size, n);
        this.size += n;
    }

    public void set(byte[] byArray, int n) {
        this.a = byArray;
        this.size = n;
    }

    public void set(int n, byte by) {
        this.resize();
        this.a[n] = by;
        if (n >= this.size) {
            this.size = n + 1;
        }
    }

    public void resize(int n) {
        if (n > this.a.length) {
            int n2 = this.a.length * 3 / 2 + 1;
            if (n2 < n) {
                n2 = n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.a, 0, byArray, 0, this.size);
            this.a = byArray;
        }
    }

    private void resize() {
        if (this.size == this.a.length) {
            this.resize(this.size * 3 / 2 + 1);
        }
    }

    public byte at(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.a[n];
    }

    public byte get(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.a[n];
    }

    public byte first() {
        return this.size == 0 ? (byte)0 : this.a[0];
    }

    public byte last() {
        return this.size() == 0 ? (byte)0 : this.a[this.size - 1];
    }

    public byte remove(int n) {
        byte by = this.get(n);
        if (n != this.size - 1) {
            System.arraycopy(this.a, n + 1, this.a, n, this.size - 1 - n);
        }
        --this.size;
        return by;
    }

    public byte remove(int n, int n2) {
        byte by = this.get(n);
        if (n != this.size - 1) {
            System.arraycopy(this.a, n + n2, this.a, n, this.size - n2 - n);
        }
        this.size -= n2;
        return by;
    }

    public byte removeLast() {
        return this.size() == 0 ? (byte)0 : this.remove(this.size - 1);
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toByteArray() {
        return this.toByteArray(true);
    }

    public byte[] toByteArray(boolean bl) {
        if (bl || this.a.length != this.size) {
            byte[] byArray = new byte[this.size];
            System.arraycopy(this.a, 0, byArray, 0, this.size);
            return byArray;
        }
        return this.a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ByteList) {
            return this.equals((ByteList)object);
        }
        return false;
    }

    public boolean equals(ByteList byteList) {
        if (byteList == null) {
            return false;
        }
        if (this.size != byteList.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.a[i] == byteList.a[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = 31 * n + this.a[i];
        }
        return n;
    }
}

