/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flash.swf.tags.DefineTag;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.i18n.TranslationFormat;
import flex2.compiler.io.InMemoryFile;
import flex2.compiler.io.ResourceFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.swc.Component;
import flex2.compiler.swc.Swc;
import flex2.compiler.swc.SwcCache;
import flex2.compiler.swc.SwcDependencySet;
import flex2.compiler.swc.SwcGroup;
import flex2.compiler.swc.SwcPathResolver;
import flex2.compiler.swc.SwcScript;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.MultiName;
import flex2.compiler.util.NameFormatter;
import flex2.compiler.util.NameMappings;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.oem.Script;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerSwcContext {
    private static final String DOT_CSS = ".css";
    private static final String DOT_PROPERTIES = ".properties";
    private static final String LOCALE_SLASH = "locale/";
    private String compatibilityVersionString;
    private boolean locked = false;
    private SwcGroup swcGroup;
    private QNameMap def2source = new QNameMap();
    private QNameMap def2script = new QNameMap();
    private Map name2source = new HashMap();
    private Map name2script = new HashMap();
    private QNameMap rb2source = new QNameMap();
    private QNameMap rb2file = new QNameMap();
    private Set components;
    private Set packageNames = new HashSet();
    private Set externs = new HashSet();
    private Set includes = new HashSet();
    private Map resourceIncludes = new HashMap();
    private Map files = new HashMap();
    private int loaded = 0;
    private List defaultsStyles = new LinkedList();
    private List themeStyles = new LinkedList();
    private List errlocations = new LinkedList();
    private StringBuffer ts = new StringBuffer();
    private boolean fullCompile;
    private boolean enableIncrementalCompile;

    public CompilerSwcContext(String compatibilityVersionString) {
        this(true, false, compatibilityVersionString);
    }

    public CompilerSwcContext(boolean fullCompile, boolean enableIncrementalCompile, String compatibilityVersionString) {
        this.fullCompile = fullCompile;
        this.enableIncrementalCompile = enableIncrementalCompile;
        this.compatibilityVersionString = compatibilityVersionString;
    }

    public int load(VirtualFile[] libPath, VirtualFile[] rslPath, VirtualFile[] themeFiles, VirtualFile[] includeLibraries, NameMappings mappings, TranslationFormat format, SwcCache swcCache) {
        SwcGroup libGroup = null;
        if (libPath != null && libPath.length > 0) {
            libGroup = swcCache.getSwcGroup(libPath);
            this.lookupDefaultsStyles(libGroup);
            this.addTimeStamps(libGroup);
        }
        SwcGroup rslGroup = null;
        if (rslPath != null && rslPath.length > 0) {
            rslGroup = swcCache.getSwcGroup(rslPath);
            this.externs.addAll(rslGroup.getScriptMap().keySet());
            this.lookupDefaultsStyles(rslGroup);
            this.addTimeStamps(rslGroup);
        }
        SwcGroup includeGroup = null;
        if (includeLibraries != null && includeLibraries.length > 0) {
            includeGroup = swcCache.getSwcGroup(includeLibraries);
            this.includes.addAll(includeGroup.getScriptMap().keySet());
            this.addResourceIncludes(includeGroup.getFiles());
            this.lookupDefaultsStyles(includeGroup);
            this.addTimeStamps(includeGroup);
            this.files.putAll(includeGroup.getFiles());
        }
        LinkedList<SwcGroup> groupList = new LinkedList<SwcGroup>();
        groupList.add(libGroup);
        groupList.add(rslGroup);
        groupList.add(includeGroup);
        for (int i = 0; themeFiles != null && i < themeFiles.length; ++i) {
            if (themeFiles[i].getName().endsWith(DOT_CSS)) {
                this.themeStyles.add(themeFiles[i]);
                this.ts.append(themeFiles[i].getLastModified());
                continue;
            }
            SwcGroup tmpThemeGroup = swcCache.getSwcGroup(new VirtualFile[]{themeFiles[i]});
            groupList.add(tmpThemeGroup);
            Iterator it = tmpThemeGroup.getFiles().values().iterator();
            while (it.hasNext()) {
                VirtualFile f = (VirtualFile)it.next();
                this.ts.append(f.getLastModified());
                if (!f.getName().endsWith(DOT_CSS)) continue;
                this.themeStyles.add(f);
            }
        }
        this.swcGroup = swcCache.getSwcGroup(groupList);
        if (this.swcGroup == null) {
            return 0;
        }
        this.toQNameMap(this.def2script, this.name2script, this.swcGroup.getScriptMap());
        this.updateResourceBundles(this.swcGroup.getFiles(), format);
        Set qnames = this.swcGroup.getQNames();
        Iterator iterator = qnames.iterator();
        while (iterator.hasNext()) {
            QName qName = (QName)iterator.next();
            this.packageNames.add(qName.getNamespace());
        }
        ThreadLocalToolkit.getPathResolver().addSinglePathResolver(new SwcPathResolver(this.swcGroup.getFiles()));
        mappings.addMappings(this.swcGroup.getNameMappings());
        int num = this.swcGroup.getNumberLoaded();
        this.loaded += num;
        return num;
    }

    public int load(VirtualFile[] libPath, NameMappings mappings, String resourceFileExt, SwcCache swcCache) {
        int retval = this.load(libPath, null, null, null, mappings, null, swcCache);
        if (this.swcGroup != null) {
            this.updateResourceBundles(this.swcGroup.getFiles(), resourceFileExt);
        }
        return retval;
    }

    private void addResourceIncludes(Map files) {
        Iterator iterator = files.keySet().iterator();
        while (iterator.hasNext()) {
            String fileName = (String)iterator.next();
            if (!fileName.startsWith(LOCALE_SLASH) || !fileName.endsWith(DOT_PROPERTIES)) continue;
            int begin = LOCALE_SLASH.length();
            begin = fileName.indexOf("/", begin) + 1;
            int end = fileName.length() - DOT_PROPERTIES.length();
            this.resourceIncludes.put(fileName.substring(begin, end).replace('/', '.'), files.get(fileName));
        }
    }

    private void lookupDefaultsStyles(SwcGroup swcGroup) {
        Iterator iterator = swcGroup.getSwcs().values().iterator();
        String versionDefaultsCssFileName = null;
        if (this.compatibilityVersionString != null) {
            versionDefaultsCssFileName = "defaults-" + this.compatibilityVersionString + DOT_CSS;
        }
        while (iterator.hasNext()) {
            Swc swc = (Swc)iterator.next();
            VirtualFile defaultsCssFile = null;
            if (versionDefaultsCssFileName != null) {
                defaultsCssFile = swc.getFile(versionDefaultsCssFileName);
            }
            if (defaultsCssFile == null) {
                defaultsCssFile = swc.getFile("defaults.css");
            }
            if (defaultsCssFile == null) continue;
            this.defaultsStyles.add(defaultsCssFile);
        }
    }

    public VirtualFile getFile(String name) {
        return this.swcGroup != null ? this.swcGroup.getFile(name) : null;
    }

    public Map getFiles() {
        return this.swcGroup != null ? this.swcGroup.getFiles() : Collections.EMPTY_MAP;
    }

    private void addTimeStamps(SwcGroup libGroup) {
        if (libGroup != null) {
            List lastModified = libGroup.getSwcTimes();
            int size = lastModified.size();
            for (int i = 0; i < size; ++i) {
                this.ts.append(lastModified.get(i));
            }
        }
    }

    public VirtualFile[] getVirtualFiles(String[] locales, String namespaceURI, String localPart) {
        Map rbFiles = (Map)this.rb2file.get(namespaceURI, localPart);
        if (rbFiles == null || locales.length == 0) {
            return null;
        }
        VirtualFile[] rbList = locales.length == 0 ? null : new VirtualFile[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            rbList[i] = (VirtualFile)rbFiles.get(locales[i]);
        }
        return rbList;
    }

    public Source getResourceBundle(String[] locales, String namespaceURI, String localPart) {
        if (locales.length == 0) {
            return null;
        }
        if (this.rb2source.containsKey(namespaceURI, localPart)) {
            return (Source)this.rb2source.get(namespaceURI, localPart);
        }
        Source s = null;
        VirtualFile[] rbList = this.getVirtualFiles(locales, namespaceURI, localPart);
        if (rbList != null && rbList.length > 0) {
            String name = null;
            for (int i = 0; i < rbList.length; ++i) {
                if (rbList[i] == null) continue;
                name = rbList[i].getName();
                break;
            }
            if (name != null) {
                s = new Source(new ResourceFile(name, locales, rbList, new VirtualFile[rbList.length]), null, namespaceURI.replace('.', '/'), localPart, this, false, false, false);
                this.rb2source.put(namespaceURI, localPart, s);
            }
        }
        return s;
    }

    public Source getSource(String name) {
        if (this.name2source.containsKey(name)) {
            return (Source)this.name2source.get(name);
        }
        SwcScript script = (SwcScript)this.name2script.get(name);
        Source s = this.createSource(script);
        if (s != null) {
            this.name2source.put(name, s);
            Iterator i = s.getCompilationUnit().topLevelDefinitions.iterator();
            while (i.hasNext()) {
                QName qName = (QName)i.next();
                this.def2source.put(qName.getNamespace(), qName.getLocalPart(), s);
            }
        }
        return s;
    }

    public Source getSource(String namespaceURI, String localPart) {
        if (this.def2source.containsKey(namespaceURI, localPart)) {
            return (Source)this.def2source.get(namespaceURI, localPart);
        }
        SwcScript script = (SwcScript)this.def2script.get(namespaceURI, localPart);
        Source s = this.createSource(script);
        if (s != null) {
            this.def2source.put(namespaceURI, localPart, s);
            this.name2source.put(s.getName(), s);
        }
        return s;
    }

    private Source createSource(SwcScript script) {
        if (script == null) {
            return null;
        }
        String loc = script.getLibrary().getSwcLocation();
        InMemoryFile f = new InMemoryFile(script.getDoABC().abc, loc + "(" + script.getName() + ")", "application/x-actionscript-bytecode", script.getLastModified());
        Source s = loc.endsWith("playerglobal.swc") || loc.endsWith("airglobal.swc") || loc.endsWith("avmplus.swc") ? new Source((VirtualFile)f, "", "", script, true, false, false) : new Source((VirtualFile)f, "", "", script, false, false, false);
        s.setPathResolver(null);
        CompilationUnit u = s.newCompilationUnit(null, new Context());
        u.setSignatureChecksum(script.getSignatureChecksum());
        Iterator i = script.getDefinitionIterator();
        while (i.hasNext()) {
            u.topLevelDefinitions.add(new QName((String)i.next()));
        }
        SwcDependencySet set = script.getDependencySet();
        Iterator i2 = set.getDependencyIterator("i");
        while (i2 != null && i2.hasNext()) {
            u.inheritance.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("s");
        while (i2 != null && i2.hasNext()) {
            u.types.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("n");
        while (i2 != null && i2.hasNext()) {
            u.namespaces.add(new MultiName((String)i2.next()));
        }
        i2 = set.getDependencyIterator("e");
        while (i2 != null && i2.hasNext()) {
            u.expressions.add(new MultiName((String)i2.next()));
        }
        i2 = script.getSymbolClasses().iterator();
        while (i2.hasNext()) {
            u.expressions.add(new MultiName((String)i2.next()));
        }
        HashMap misc = script.getMiscData();
        if (misc == null) {
            if (this.enableIncrementalCompile) {
                misc = new HashMap(4);
                script.setMiscData(misc);
            }
        } else if (!this.fullCompile && misc.containsKey(CompilationUnit.COMPILATION_UNIT)) {
            CompilationUnit oldUnit = (CompilationUnit)misc.get(CompilationUnit.COMPILATION_UNIT);
            Source.copyMetaData(oldUnit, u);
        }
        u.getContext().setAttribute("SwcScript.misc", misc);
        Iterator i3 = script.getDefinitionIterator();
        while (i3.hasNext()) {
            String name = (String)i3.next();
            DefineTag tag = script.getLibrary().getSymbol(name);
            if (tag == null) continue;
            u.getAssets().add(name, tag);
        }
        if (loc.trim().length() < loc.length()) {
            this.errlocations.add(loc.trim());
            return null;
        }
        return s;
    }

    public int getNumberLoaded() {
        return this.loaded;
    }

    public Set getExterns() {
        return this.externs;
    }

    public Set getIncludes() {
        return this.includes;
    }

    public Map getResourceIncludes() {
        return this.resourceIncludes;
    }

    public Map getIncludeFiles() {
        return this.files;
    }

    public boolean hasPackage(String packageName) {
        return this.packageNames.contains(packageName);
    }

    public boolean hasDefinition(QName qName) {
        return this.def2script.get(qName.getNamespace(), qName.getLocalPart()) != null;
    }

    public List getDefaultsStyleSheets() {
        return this.defaultsStyles;
    }

    public List getThemeStyleSheets() {
        return this.themeStyles;
    }

    public List errorLocations() {
        return this.errlocations;
    }

    public int checksum() {
        byte[] b = null;
        try {
            b = this.ts.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            b = this.ts.toString().getBytes();
        }
        int checksum = 0;
        for (int i = 0; i < b.length; ++i) {
            checksum += b[i];
        }
        return checksum;
    }

    public void close() {
        if (!this.locked && this.swcGroup != null) {
            this.swcGroup.close();
        }
    }

    public void setLock(boolean lock) {
        this.locked = lock;
    }

    public Swc getSwc(String name) {
        return this.swcGroup != null ? this.swcGroup.getSwc(name) : null;
    }

    private void toQNameMap(QNameMap qNameMap, Map scriptNameMap, Map scriptMap) {
        Iterator i = scriptMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            SwcScript value = (SwcScript)scriptMap.get(key);
            qNameMap.put(new QName(key), value);
        }
    }

    private void updateResourceBundles(Map files, TranslationFormat format) {
        Iterator i = files.keySet().iterator();
        while (format != null && i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith(LOCALE_SLASH)) continue;
            VirtualFile file = (VirtualFile)files.get(name);
            int prefixLength = LOCALE_SLASH.length();
            int index = name.indexOf(47, prefixLength);
            String mimeType = file.getMimeType();
            if (index == -1 || !format.isSupported(mimeType)) continue;
            String locale = name.substring(prefixLength, index);
            String ext = MimeMappings.getExtension(mimeType);
            QName rbName = new QName(NameFormatter.toColon(name.substring(index + 1, name.length() - ext.length()).replace('/', '.')));
            HashMap<String, VirtualFile> rbFiles = (HashMap<String, VirtualFile>)this.rb2file.get(rbName);
            if (rbFiles == null) {
                rbFiles = new HashMap<String, VirtualFile>();
                this.rb2file.put(rbName, rbFiles);
            }
            rbFiles.put(locale, file);
        }
    }

    private void updateResourceBundles(Map files, String ext) {
        Iterator i = files.keySet().iterator();
        while (ext != null && i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith(LOCALE_SLASH) || !name.endsWith(ext)) continue;
            VirtualFile file = (VirtualFile)files.get(name);
            int prefixLength = LOCALE_SLASH.length();
            int index = name.indexOf(47, prefixLength);
            if (index == -1) continue;
            String locale = name.substring(prefixLength, index);
            QName rbName = new QName(NameFormatter.toColon(name.substring(index + 1, name.length() - ext.length()).replace('/', '.')));
            HashMap<String, VirtualFile> rbFiles = (HashMap<String, VirtualFile>)this.rb2file.get(rbName);
            if (rbFiles == null) {
                rbFiles = new HashMap<String, VirtualFile>();
                this.rb2file.put(rbName, rbFiles);
            }
            rbFiles.put(locale, file);
        }
    }

    public Iterator getDefinitionIterator() {
        return this.def2script.keySet().iterator();
    }

    public Script getScript(QName def, boolean includeBytecodes) {
        SwcScript s = (SwcScript)this.def2script.get(def);
        return s != null ? s.toScript(includeBytecodes) : null;
    }

    public Iterator getComponentIterator() {
        if (this.components == null) {
            this.components = new HashSet();
            Iterator i = this.getDefinitionIterator();
            while (i.hasNext()) {
                QName def = (QName)i.next();
                SwcScript script = (SwcScript)this.def2script.get(def);
                Component c = script.getLibrary().getSwc().getComponent(def.toString());
                if (c == null) continue;
                this.components.add(c);
            }
        }
        return this.components.iterator();
    }

    public NameMappings getNameMappings() {
        return this.swcGroup != null ? this.swcGroup.getNameMappings() : null;
    }

    public Long getChecksum(QName def) {
        if (def == null) {
            throw new NullPointerException("getCheckSum: def may not be null");
        }
        SwcScript script = (SwcScript)this.def2script.get(def);
        if (script != null) {
            return script.getSignatureChecksum();
        }
        return null;
    }
}

