/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.expression;

import flash.localization.LocalizationManager;
import flash.tools.debugger.DebuggerLocalizer;
import flash.tools.debugger.expression.ConstantBooleanExp;
import flash.tools.debugger.expression.ConstantExp;
import flash.tools.debugger.expression.IASTBuilder;
import flash.tools.debugger.expression.IncompleteExpressionException;
import flash.tools.debugger.expression.InternalVariableExp;
import flash.tools.debugger.expression.NonTerminalExp;
import flash.tools.debugger.expression.Operator;
import flash.tools.debugger.expression.SingleArgumentExp;
import flash.tools.debugger.expression.StringExp;
import flash.tools.debugger.expression.UnknownOperationException;
import flash.tools.debugger.expression.ValueExp;
import flash.tools.debugger.expression.VariableExp;
import flash.util.Trace;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;

public class ASTBuilder
implements IASTBuilder {
    private static LocalizationManager m_localizationManager = new LocalizationManager();
    private Stack m_expStack = new Stack();
    private OperatorStack m_opStack = new OperatorStack();
    private boolean m_readerEOF = false;
    private int m_parsePos = 0;
    private boolean m_isIndirectionOperatorAllowed = true;

    public ASTBuilder(boolean isIndirectionOperatorAllowed) {
        this.m_isIndirectionOperatorAllowed = isIndirectionOperatorAllowed;
    }

    public boolean isIndirectionOperatorAllowed() {
        return this.m_isIndirectionOperatorAllowed;
    }

    private ValueExp done() throws EmptyStackException, UnknownOperationException, IncompleteExpressionException {
        while (!this.m_opStack.empty()) {
            this.popOperation();
        }
        ValueExp tree = (ValueExp)this.m_expStack.pop();
        if (!this.m_expStack.empty() || !this.m_opStack.empty()) {
            while (!this.m_expStack.empty()) {
                this.m_expStack.pop();
            }
            while (!this.m_opStack.empty()) {
                this.m_opStack.pop();
            }
            throw new IncompleteExpressionException();
        }
        return tree;
    }

    private void addOp(Operator opType) throws EmptyStackException, UnknownOperationException, ParseException {
        if (opType == Operator.OPEN_PAREN) {
            this.m_opStack.push(opType);
        } else if (opType == Operator.OPEN_BRACKET) {
            this.addOp(Operator.SUBSCRIPT);
            this.m_opStack.push(opType);
        } else if (opType == Operator.CLOSE_PAREN || opType == Operator.CLOSE_BRACKET) {
            Operator openingOpType = opType == Operator.CLOSE_PAREN ? Operator.OPEN_PAREN : Operator.OPEN_BRACKET;
            while (this.m_opStack.peek() != Operator.OPEN_PAREN && this.m_opStack.peek() != Operator.OPEN_BRACKET) {
                this.popOperation();
            }
            if (this.m_opStack.peek() != openingOpType) {
                throw new ParseException(ASTBuilder.getLocalizationManager().getLocalizedTextString("key1"), this.m_parsePos);
            }
            this.popOperation();
        } else {
            while (!this.m_opStack.empty() && this.m_opStack.peek().precedence >= opType.precedence) {
                this.popOperation();
            }
            this.m_opStack.push(opType);
        }
    }

    private void addVariable(String name) {
        VariableExp node = VariableExp.create(name);
        this.m_expStack.push(node);
    }

    private void addInternalVariable(String name) {
        VariableExp node = InternalVariableExp.create(name);
        this.m_expStack.push(node);
    }

    private void addLong(long value) {
        ConstantExp node = ConstantExp.create(value);
        this.m_expStack.push(node);
    }

    private void addBoolean(boolean value) {
        ConstantBooleanExp node = ConstantBooleanExp.create(value);
        this.m_expStack.push(node);
    }

    private void addString(String text) {
        StringExp node = StringExp.create(text);
        this.m_expStack.push(node);
    }

    private void popOperation() throws UnknownOperationException {
        Operator op = this.m_opStack.pop();
        if (op.precedence < 0) {
            return;
        }
        if (this.isIndirectionOperatorAllowed() && op == Operator.DIRECT_SELECT && this.m_expStack.size() < 2) {
            op = Operator.INDIRECTION;
        }
        NonTerminalExp node = op.createExpNode();
        node.setRightChild((ValueExp)this.m_expStack.pop());
        if (!(node instanceof SingleArgumentExp)) {
            node.setLeftChild((ValueExp)this.m_expStack.pop());
        }
        this.m_expStack.push(node);
    }

    public ValueExp parse(Reader in) throws IOException, EmptyStackException, UnknownOperationException, IncompleteExpressionException, ParseException {
        return this.parse(in, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueExp parse(Reader in, boolean ignoreUnknownCharacters) throws IOException, EmptyStackException, UnknownOperationException, IncompleteExpressionException, ParseException {
        try {
            StringBuffer sb = new StringBuffer();
            boolean skipRead = false;
            boolean inDot = false;
            char ch = ' ';
            this.m_readerEOF = false;
            this.m_parsePos = 0;
            while (!this.m_readerEOF) {
                if (!skipRead) {
                    ch = this.readChar(in);
                }
                if (this.m_readerEOF || Character.isWhitespace(ch)) {
                    skipRead = false;
                    inDot = false;
                    continue;
                }
                if (!inDot && Character.isDigit(ch)) {
                    int base = 10;
                    long n = Character.digit(ch, base);
                    ch = this.readChar(in);
                    if (ch == 'x' || ch == 'X') {
                        base = 16;
                        ch = this.readChar(in);
                    }
                    while (Character.isLetterOrDigit(ch)) {
                        n = n * (long)base + (long)Character.digit(ch, base);
                        ch = this.readChar(in);
                    }
                    this.addLong(n);
                    skipRead = true;
                    continue;
                }
                if (ch == '$') {
                    sb.setLength(0);
                    do {
                        sb.append(ch);
                    } while (Character.isJavaIdentifierPart(ch = this.readChar(in)));
                    this.addInternalVariable(sb.toString());
                    sb.setLength(0);
                    skipRead = true;
                    continue;
                }
                if (Character.isJavaIdentifierStart(ch) || ch == '#' || Character.isDigit(ch) && inDot) {
                    sb.setLength(0);
                    do {
                        sb.append(ch);
                    } while (Character.isJavaIdentifierPart(ch = this.readChar(in)));
                    String s = sb.toString();
                    if (s.equals("true")) {
                        this.addBoolean(true);
                    } else if (s.equals("false")) {
                        this.addBoolean(false);
                    } else {
                        this.addVariable(s);
                    }
                    sb.setLength(0);
                    skipRead = true;
                    continue;
                }
                if (ch == '\'' || ch == '\"') {
                    char matching = ch;
                    do {
                        ch = this.readChar(in);
                        sb.append(ch);
                    } while (!this.m_readerEOF && ch != matching);
                    int to = sb.length() - 1;
                    this.addString(sb.toString().substring(0, to));
                    sb.setLength(0);
                    skipRead = false;
                    continue;
                }
                if (inDot && ch == '*') {
                    this.addVariable("*");
                    inDot = false;
                    skipRead = false;
                    continue;
                }
                char lookaheadCh = this.readChar(in);
                Operator op = Operator.opFor(ch, lookaheadCh, this.isIndirectionOperatorAllowed());
                if (op == Operator.UNKNOWN && !ignoreUnknownCharacters) {
                    HashMap<String, String> args = new HashMap<String, String>();
                    args.put("arg1", "" + ch);
                    throw new ParseException(ASTBuilder.getLocalizationManager().getLocalizedTextString("key2", args), this.m_parsePos);
                }
                this.addOp(op);
                boolean bl = skipRead = op.token.length() == 1 || op == Operator.INDIRECTION;
                if (skipRead) {
                    ch = lookaheadCh;
                }
                inDot = op == Operator.DIRECT_SELECT;
            }
            ValueExp valueExp = this.done();
            return valueExp;
        }
        finally {
            this.m_expStack.clear();
            this.m_opStack.clear();
        }
    }

    private char readChar(Reader in) throws IOException {
        int c = 32;
        if (!this.m_readerEOF) {
            c = in.read();
            ++this.m_parsePos;
            if (c < 0) {
                this.m_readerEOF = true;
            }
        }
        return (char)c;
    }

    public static final void main(String[] args) {
        block2: {
            ASTBuilder ab = new ASTBuilder(true);
            try {
                ab.addLong(5L);
                ab.addOp(Operator.ARITH_SUB);
                ab.addLong(6L);
                ValueExp exp1 = ab.done();
                ab.addLong(5L);
                ab.addOp(Operator.ARITH_ADD);
                ab.addOp(Operator.OPEN_PAREN);
                ab.addLong(6L);
                ab.addOp(Operator.ARITH_DIV);
                ab.addLong(4L);
                ab.addOp(Operator.ARITH_MULT);
                ab.addLong(7L);
                ab.addOp(Operator.CLOSE_PAREN);
                ab.addOp(Operator.BITWISE_RSHIFT);
                ab.addLong(2L);
                ValueExp exp2 = ab.done();
                ValueExp exp3 = ab.parse(new StringReader("5-6"));
                ValueExp exp4 = ab.parse(new StringReader("5 +(6/4*7 )>>2"));
                ValueExp exp5 = ab.parse(new StringReader(" 4 == 2"));
                Object o1 = exp1.evaluate(null);
                Object o2 = exp2.evaluate(null);
                Object o3 = exp3.evaluate(null);
                Object o4 = exp4.evaluate(null);
                Object o5 = exp5.evaluate(null);
                System.out.println("=" + o1 + "," + o2);
                System.out.println("=" + o3 + "," + o4);
                System.out.println("=" + o5);
            }
            catch (Exception e) {
                if (!Trace.error) break block2;
                e.printStackTrace();
            }
        }
    }

    static LocalizationManager getLocalizationManager() {
        return m_localizationManager;
    }

    static {
        m_localizationManager.addLocalizer(new DebuggerLocalizer("flash.tools.debugger.expression.expression."));
    }

    private static class OperatorStack {
        private Stack m_stack = new Stack();

        private OperatorStack() {
        }

        public void push(Operator op) {
            this.m_stack.push(op);
        }

        public Operator pop() {
            return (Operator)this.m_stack.pop();
        }

        public boolean empty() {
            return this.m_stack.empty();
        }

        public Operator peek() {
            return (Operator)this.m_stack.peek();
        }

        public int size() {
            return this.m_stack.size();
        }

        public void clear() {
            this.m_stack.clear();
        }
    }
}

