/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.people;

import com.aetrion.flickr.contacts.OnlineStatus;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class User
implements Serializable {
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String id;
    private String username;
    private boolean admin;
    private boolean pro;
    private int iconFarm;
    private int iconServer;
    private String realName;
    private String location;
    private Date photosFirstDate;
    private Date photosFirstDateTaken;
    private Date faveDate;
    private int photosCount;
    private OnlineStatus online;
    private String awayMessage;
    private long bandwidthMax;
    private long bandwidthUsed;
    private long filesizeMax;
    private String mbox_sha1sum;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isPro() {
        return this.pro;
    }

    public void setPro(boolean pro) {
        this.pro = pro;
    }

    public int getIconFarm() {
        return this.iconFarm;
    }

    public void setIconFarm(int iconFarm) {
        this.iconFarm = iconFarm;
    }

    public void setIconFarm(String iconFarm) {
        if (iconFarm != null) {
            this.setIconFarm(Integer.parseInt(iconFarm));
        }
    }

    public int getIconServer() {
        return this.iconServer;
    }

    public void setIconServer(int iconServer) {
        this.iconServer = iconServer;
    }

    public void setIconServer(String iconServer) {
        if (iconServer != null) {
            this.setIconServer(Integer.parseInt(iconServer));
        }
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBuddyIconUrl() {
        String iconUrl = "http://www.flickr.com/images/buddyicon.jpg";
        if (this.iconServer > 0) {
            iconUrl = "http://farm" + this.iconFarm + ".static.flickr.com/" + this.iconServer + "/buddyicons/" + this.id + ".jpg";
        }
        return iconUrl;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Date getPhotosFirstDate() {
        return this.photosFirstDate;
    }

    public void setPhotosFirstDate(Date photosFirstDate) {
        this.photosFirstDate = photosFirstDate;
    }

    public void setPhotosFirstDate(long photosFirstDate) {
        this.setPhotosFirstDate(new Date(photosFirstDate));
    }

    public void setPhotosFirstDate(String photosFirstDate) {
        if (photosFirstDate != null) {
            this.setPhotosFirstDate(Long.parseLong(photosFirstDate) * 1000L);
        }
    }

    public Date getPhotosFirstDateTaken() {
        return this.photosFirstDateTaken;
    }

    public void setPhotosFirstDateTaken(Date photosFirstDateTaken) {
        this.photosFirstDateTaken = photosFirstDateTaken;
    }

    public void setPhotosFirstDateTaken(String photosFirstDateTaken) {
        if (photosFirstDateTaken != null) {
            try {
                this.setPhotosFirstDateTaken(DF.parse(photosFirstDateTaken));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setFaveDate(String faveDate) {
        this.setFaveDate(Long.parseLong(faveDate) * 1000L);
    }

    public void setFaveDate(long faveDate) {
        this.setFaveDate(new Date(faveDate));
    }

    public void setFaveDate(Date faveDate) {
        this.faveDate = faveDate;
    }

    public Date getFaveDate() {
        return this.faveDate;
    }

    public int getPhotosCount() {
        return this.photosCount;
    }

    public void setPhotosCount(int photosCount) {
        this.photosCount = photosCount;
    }

    public void setPhotosCount(String photosCount) {
        if (photosCount != null) {
            this.setPhotosCount(Integer.parseInt(photosCount));
        }
    }

    public OnlineStatus getOnline() {
        return this.online;
    }

    public void setOnline(OnlineStatus online) {
        this.online = online;
    }

    public String getAwayMessage() {
        return this.awayMessage;
    }

    public void setAwayMessage(String awayMessage) {
        this.awayMessage = awayMessage;
    }

    public long getBandwidthMax() {
        return this.bandwidthMax;
    }

    public void setBandwidthMax(long bandwidthMax) {
        this.bandwidthMax = bandwidthMax;
    }

    public void setBandwidthMax(String bandwidthMax) {
        if (bandwidthMax != null) {
            this.setBandwidthMax(Integer.parseInt(bandwidthMax));
        }
    }

    public long getBandwidthUsed() {
        return this.bandwidthUsed;
    }

    public void setBandwidthUsed(long bandwidthUsed) {
        this.bandwidthUsed = bandwidthUsed;
    }

    public void setBandwidthUsed(String bandwidthUsed) {
        if (bandwidthUsed != null) {
            this.setBandwidthUsed(Integer.parseInt(bandwidthUsed));
        }
    }

    public long getFilesizeMax() {
        return this.filesizeMax;
    }

    public void setFilesizeMax(long filesizeMax) {
        this.filesizeMax = filesizeMax;
    }

    public void setFilesizeMax(String filesizeMax) {
        if (filesizeMax != null) {
            this.setFilesizeMax(Integer.parseInt(filesizeMax));
        }
    }

    public void setMbox_sha1sum(String mbox_sha1sum) {
        this.mbox_sha1sum = mbox_sha1sum;
    }

    public String getMbox_sha1sum() {
        return this.mbox_sha1sum;
    }
}

