/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.photos;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.people.User;
import com.aetrion.flickr.photos.Editability;
import com.aetrion.flickr.photos.GeoData;
import com.aetrion.flickr.photos.Permissions;
import com.aetrion.flickr.util.IOUtilities;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import javax.imageio.ImageIO;

public class Photo {
    private static final DateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String DEFAULT_ORIGINAL_IMAGE_SUFFIX = "_o.jpg";
    private static final String SMALL_SQUARE_IMAGE_SUFFIX = "_s.jpg";
    private static final String SMALL_IMAGE_SUFFIX = "_m.jpg";
    private static final String THUMBNAIL_IMAGE_SUFFIX = "_t.jpg";
    private static final String MEDIUM_IMAGE_SUFFIX = ".jpg";
    private static final String LARGE_IMAGE_SUFFIX = "_b.jpg";
    private String id;
    private User owner;
    private String secret;
    private String farm;
    private String server;
    private boolean favorite;
    private String license;
    private boolean primary;
    private String title;
    private String description;
    private boolean publicFlag;
    private boolean friendFlag;
    private boolean familyFlag;
    private Date dateAdded;
    private Date datePosted;
    private Date dateTaken;
    private Date lastUpdate;
    private String takenGranularity;
    private Permissions permissions;
    private Editability editability;
    private int comments;
    private int views;
    private int rotation;
    private Collection notes;
    private Collection tags;
    private Collection urls;
    private String iconServer;
    private String iconFarm;
    private String url;
    private GeoData geoData;
    private String originalFormat;
    private String originalSecret;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getFarm() {
        return this.farm;
    }

    public void setFarm(String farm) {
        this.farm = farm;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean favorite) {
        this.favorite = favorite;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setPrimary(String primary) {
        this.setPrimary("1".equals(primary));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPublicFlag() {
        return this.publicFlag;
    }

    public void setPublicFlag(boolean publicFlag) {
        this.publicFlag = publicFlag;
    }

    public boolean isFriendFlag() {
        return this.friendFlag;
    }

    public void setFriendFlag(boolean friendFlag) {
        this.friendFlag = friendFlag;
    }

    public boolean isFamilyFlag() {
        return this.familyFlag;
    }

    public void setFamilyFlag(boolean familyFlag) {
        this.familyFlag = familyFlag;
    }

    public Date getDateAdded() {
        return this.dateAdded;
    }

    public void setDateAdded(Date dateAdded) {
        this.dateAdded = dateAdded;
    }

    public void setDateAdded(long dateAdded) {
        this.setDateAdded(new Date(dateAdded));
    }

    public void setDateAdded(String dateAdded) {
        if (dateAdded == null || "".equals(dateAdded)) {
            return;
        }
        this.setDateAdded(Long.parseLong(dateAdded) * 1000L);
    }

    public Date getDatePosted() {
        return this.datePosted;
    }

    public void setDatePosted(Date datePosted) {
        this.datePosted = datePosted;
    }

    public void setDatePosted(long datePosted) {
        this.setDatePosted(new Date(datePosted));
    }

    public void setDatePosted(String datePosted) {
        if (datePosted == null || "".equals(datePosted)) {
            return;
        }
        this.setDatePosted(Long.parseLong(datePosted) * 1000L);
    }

    public Date getDateTaken() {
        return this.dateTaken;
    }

    public void setDateTaken(Date dateTaken) {
        this.dateTaken = dateTaken;
    }

    public void setDateTaken(String dateTaken) {
        if (dateTaken == null || "".equals(dateTaken)) {
            return;
        }
        try {
            this.setDateTaken(DF.parse(dateTaken));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setLastUpdate(String lastUpdateStr) {
        if (lastUpdateStr == null || "".equals(lastUpdateStr)) {
            return;
        }
        long unixTime = Long.parseLong(lastUpdateStr);
        this.setLastUpdate(new Date(unixTime * 1000L));
    }

    public String getTakenGranularity() {
        return this.takenGranularity;
    }

    public void setTakenGranularity(String takenGranularity) {
        this.takenGranularity = takenGranularity;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public Editability getEditability() {
        return this.editability;
    }

    public void setEditability(Editability editability) {
        this.editability = editability;
    }

    public int getComments() {
        return this.comments;
    }

    public void setComments(int comments) {
        this.comments = comments;
    }

    public void setComments(String comments) {
        if (comments != null) {
            this.setComments(Integer.parseInt(comments));
        }
    }

    public Collection getNotes() {
        return this.notes;
    }

    public void setNotes(Collection notes) {
        this.notes = notes;
    }

    public Collection getTags() {
        return this.tags;
    }

    public void setTags(Collection tags) {
        this.tags = tags;
    }

    public Collection getUrls() {
        return this.urls;
    }

    public void setUrls(Collection urls) {
        this.urls = urls;
    }

    public void setViews(String views) {
        if (views != null) {
            try {
                this.setViews(Integer.parseInt(views));
            }
            catch (NumberFormatException e) {
                this.setViews(-1);
            }
        }
    }

    public void setViews(int views) {
        this.views = views;
    }

    public int getViews() {
        return this.views;
    }

    public void setRotation(String rotation) {
        if (rotation != null) {
            try {
                this.setRotation(Integer.parseInt(rotation));
            }
            catch (NumberFormatException e) {
                this.setRotation(-1);
            }
        }
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public String getIconServer() {
        return this.iconServer;
    }

    public void setIconServer(String iconServer) {
        this.iconServer = iconServer;
    }

    public String getIconFarm() {
        return this.iconFarm;
    }

    public void setIconFarm(String iconFarm) {
        this.iconFarm = iconFarm;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public GeoData getGeoData() {
        return this.geoData;
    }

    public void setGeoData(GeoData geoData) {
        this.geoData = geoData;
    }

    public boolean hasGeoData() {
        return this.geoData != null;
    }

    public String getOriginalFormat() {
        return this.originalFormat;
    }

    public void setOriginalFormat(String originalFormat) {
        this.originalFormat = originalFormat;
    }

    public String getOriginalSecret() {
        return this.originalSecret;
    }

    public void setOriginalSecret(String originalSecret) {
        this.originalSecret = originalSecret;
    }

    public BufferedImage getOriginalImage() throws IOException, FlickrException {
        if (this.originalFormat != null) {
            return this.getOriginalImage("_o." + this.originalFormat);
        }
        return this.getOriginalImage(DEFAULT_ORIGINAL_IMAGE_SUFFIX);
    }

    public InputStream getOriginalAsStream() throws IOException, FlickrException {
        if (this.originalFormat != null) {
            return this.getOriginalImageAsStream("_o." + this.originalFormat);
        }
        return this.getOriginalImageAsStream(DEFAULT_ORIGINAL_IMAGE_SUFFIX);
    }

    public String getOriginalUrl() throws FlickrException {
        if (this.originalFormat != null) {
            return this.getOriginalBaseImageUrl() + "_o." + this.originalFormat;
        }
        return this.getOriginalBaseImageUrl() + DEFAULT_ORIGINAL_IMAGE_SUFFIX;
    }

    public BufferedImage getSmallSquareImage() throws IOException {
        return this.getImage(SMALL_SQUARE_IMAGE_SUFFIX);
    }

    public InputStream getSmallSquareAsInputStream() throws IOException {
        return this.getImageAsStream(SMALL_SQUARE_IMAGE_SUFFIX);
    }

    public String getSmallSquareUrl() {
        return this.getBaseImageUrl() + SMALL_SQUARE_IMAGE_SUFFIX;
    }

    public BufferedImage getThumbnailImage() throws IOException {
        return this.getImage(THUMBNAIL_IMAGE_SUFFIX);
    }

    public InputStream getThumbnailAsInputStream() throws IOException {
        return this.getImageAsStream(THUMBNAIL_IMAGE_SUFFIX);
    }

    public String getThumbnailUrl() {
        return this.getBaseImageUrl() + THUMBNAIL_IMAGE_SUFFIX;
    }

    public BufferedImage getSmallImage() throws IOException {
        return this.getImage(SMALL_IMAGE_SUFFIX);
    }

    public InputStream getSmallAsInputStream() throws IOException {
        return this.getImageAsStream(SMALL_IMAGE_SUFFIX);
    }

    public String getSmallUrl() {
        return this.getBaseImageUrl() + SMALL_IMAGE_SUFFIX;
    }

    public BufferedImage getMediumImage() throws IOException {
        return this.getImage(MEDIUM_IMAGE_SUFFIX);
    }

    public InputStream getMediumAsStream() throws IOException {
        return this.getImageAsStream(MEDIUM_IMAGE_SUFFIX);
    }

    public String getMediumUrl() {
        return this.getBaseImageUrl() + MEDIUM_IMAGE_SUFFIX;
    }

    public BufferedImage getLargeImage() throws IOException {
        return this.getImage(LARGE_IMAGE_SUFFIX);
    }

    public InputStream getLargeAsStream() throws IOException {
        return this.getImageAsStream(LARGE_IMAGE_SUFFIX);
    }

    public String getLargeUrl() {
        return this.getBaseImageUrl() + LARGE_IMAGE_SUFFIX;
    }

    private BufferedImage getImage(String suffix) throws IOException {
        StringBuffer buffer = this.getBaseImageUrl();
        buffer.append(suffix);
        return this._getImage(buffer.toString());
    }

    private BufferedImage getOriginalImage(String suffix) throws IOException, FlickrException {
        StringBuffer buffer = this.getOriginalBaseImageUrl();
        buffer.append(suffix);
        return this._getImage(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage _getImage(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        InputStream in = null;
        try {
            in = conn.getInputStream();
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        finally {
            IOUtilities.close(in);
        }
    }

    private InputStream getImageAsStream(String suffix) throws IOException {
        StringBuffer buffer = this.getBaseImageUrl();
        buffer.append(suffix);
        return this._getImageAsStream(buffer.toString());
    }

    private InputStream getOriginalImageAsStream(String suffix) throws IOException, FlickrException {
        StringBuffer buffer = this.getOriginalBaseImageUrl();
        buffer.append(suffix);
        return this._getImageAsStream(buffer.toString());
    }

    private InputStream _getImageAsStream(String urlStr) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.connect();
        return conn.getInputStream();
    }

    private StringBuffer getBaseImageUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._getBaseImageUrl());
        buffer.append(this.getSecret());
        return buffer;
    }

    private StringBuffer getOriginalBaseImageUrl() throws FlickrException, NullPointerException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._getBaseImageUrl());
        if (this.getOriginalSecret().length() <= 8) {
            throw new FlickrException("0", "OriginalUrl not available because of missing originalsecret.");
        }
        buffer.append(this.getOriginalSecret());
        return buffer;
    }

    private StringBuffer _getBaseImageUrl() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("http://farm");
        buffer.append(this.getFarm());
        buffer.append(".static.flickr.com/");
        buffer.append(this.getServer());
        buffer.append("/");
        buffer.append(this.getId());
        buffer.append("_");
        return buffer;
    }
}

