/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.metadata;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.util.Assert;

public class DashScopeAiUsage
implements Usage {
    private final DashScopeApi.TokenUsage usage;

    public static DashScopeAiUsage from(DashScopeApi.TokenUsage usage) {
        return new DashScopeAiUsage(usage);
    }

    protected DashScopeAiUsage(DashScopeApi.TokenUsage usage) {
        Assert.notNull((Object)usage, (String)"Dashscope Usage must not be null");
        this.usage = usage;
    }

    protected DashScopeApi.TokenUsage getUsage() {
        return this.usage;
    }

    public Long getPromptTokens() {
        return this.getUsage().inputTokens().longValue();
    }

    public Long getGenerationTokens() {
        return this.getUsage().outputTokens().longValue();
    }

    public Long getTotalTokens() {
        Integer totalTokens = this.getUsage().totalTokens();
        if (totalTokens != null) {
            return totalTokens.longValue();
        }
        return this.getPromptTokens() + this.getGenerationTokens();
    }

    public String toString() {
        return this.getUsage().toString();
    }
}

