/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.dashscope.rag;

import com.alibaba.cloud.ai.dashscope.api.DashScopeApi;
import com.alibaba.cloud.ai.dashscope.common.DashScopeException;
import com.alibaba.cloud.ai.dashscope.common.ErrorCodeEnum;
import com.alibaba.cloud.ai.dashscope.rag.DashScopeDocumentTransformerOptions;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentTransformer;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DashScopeDocumentTransformer
implements DocumentTransformer {
    private static final Logger logger = LoggerFactory.getLogger(DashScopeDocumentTransformer.class);
    private final DashScopeApi dashScopeApi;
    private final DashScopeDocumentTransformerOptions options;

    public DashScopeDocumentTransformer(DashScopeApi dashScopeApi) {
        this(dashScopeApi, DashScopeDocumentTransformerOptions.builder().build());
    }

    public DashScopeDocumentTransformer(DashScopeApi dashScopeApi, DashScopeDocumentTransformerOptions options) {
        Assert.notNull((Object)dashScopeApi, (String)"DashScopeApi must not be null");
        Assert.notNull((Object)options, (String)"DashScopeDocumentTransformerOptions must not be null");
        this.dashScopeApi = dashScopeApi;
        this.options = options;
    }

    private List<Document> doSplitDocuments(List<Document> documents) {
        if (CollectionUtils.isEmpty(documents)) {
            throw new RuntimeException("Documents must not be null");
        }
        if (documents.size() > 1) {
            throw new RuntimeException("Just support one Document");
        }
        Document document = documents.get(0);
        ResponseEntity<DashScopeApi.DocumentSplitResponse> splitResponseEntity = this.dashScopeApi.documentSplit(document, this.options);
        if (splitResponseEntity == null) {
            throw new DashScopeException(ErrorCodeEnum.SPLIT_DOCUMENT_ERROR);
        }
        DashScopeApi.DocumentSplitResponse splitResponse = (DashScopeApi.DocumentSplitResponse)splitResponseEntity.getBody();
        if (splitResponse == null || splitResponse.chunkService() == null || CollectionUtils.isEmpty(splitResponse.chunkService().chunkResult())) {
            logger.error("DashScopeDocumentTransformer NoSplitResult");
            throw new DashScopeException(ErrorCodeEnum.SPLIT_DOCUMENT_ERROR);
        }
        List<DashScopeApi.DocumentSplitResponse.DocumentChunk> chunkList = splitResponse.chunkService().chunkResult();
        ArrayList<Document> documentList = new ArrayList<Document>();
        chunkList.forEach(e -> {
            Document chunk = new Document(document.getId() + "_" + e.chunkId(), e.content(), document.getMetadata());
            documentList.add(chunk);
        });
        return documentList;
    }

    public List<Document> apply(List<Document> documents) {
        return this.doSplitDocuments(documents);
    }
}

