/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.commons.matcher;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.commons.matcher.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpMatcher
implements Matcher {
    private static final Logger log = LoggerFactory.getLogger(IpMatcher.class);
    private int prefixLen;
    private String ip;

    public IpMatcher() {
    }

    public IpMatcher(int prefixLen, String ip) {
        this.prefixLen = prefixLen;
        this.ip = ip;
    }

    @Override
    public boolean match(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String ip = (String)object;
        String ruleIp = this.ip2BinaryString(this.ip);
        if (StringUtils.isEmpty(ruleIp)) {
            return false;
        }
        String ipBinary = this.ip2BinaryString(ip);
        if (StringUtils.isEmpty(ipBinary)) {
            return false;
        }
        if (this.prefixLen <= 0) {
            return ruleIp.equals(ipBinary);
        }
        if (ruleIp.length() >= this.prefixLen && ipBinary.length() >= this.prefixLen) {
            return ruleIp.substring(0, this.prefixLen).equals(ipBinary.substring(0, this.prefixLen));
        }
        return false;
    }

    private String ip2BinaryString(String ip) {
        try {
            String[] ips = ip.split("\\.");
            long[] ipLong = new long[4];
            for (int i = 0; i < 4; ++i) {
                ipLong[i] = Long.parseLong(ips[i]);
                if (ipLong[i] >= 0L && ipLong[i] <= 255L) continue;
                return "";
            }
            return String.format("%32s", Long.toBinaryString((ipLong[0] << 24) + (ipLong[1] << 16) + (ipLong[2] << 8) + ipLong[3])).replace(" ", "0");
        }
        catch (Exception e) {
            log.error("failed to parse ip {} to binary string", (Object)ip);
            return "";
        }
    }

    public int getPrefixLen() {
        return this.prefixLen;
    }

    public String getIp() {
        return this.ip;
    }

    public void setPrefixLen(int prefixLen) {
        this.prefixLen = prefixLen;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }
}

