/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.ribbon;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.ribbon.ExtendBalancer;
import com.alibaba.cloud.nacos.ribbon.NacosServer;
import com.alibaba.cloud.nacos.util.InetIPv6Utils;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class NacosRule
extends AbstractLoadBalancerRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRule.class);
    private static final String IPV4_REGEX = "((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}";
    private static final String IPV6_KEY = "IPv6";
    private String ipv6;
    @Autowired
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    @Autowired
    private NacosServiceManager nacosServiceManager;
    @Autowired
    private InetIPv6Utils inetIPv6Utils;

    @PostConstruct
    public void init() {
        String ip = this.nacosDiscoveryProperties.getIp();
        this.ipv6 = StringUtils.isNotEmpty((CharSequence)ip) ? (Pattern.matches(IPV4_REGEX, ip) ? this.nacosDiscoveryProperties.getMetadata().get(IPV6_KEY) : ip) : this.getAppLocalIPv6Address();
    }

    public Server choose(Object key) {
        try {
            String clusterName = this.nacosDiscoveryProperties.getClusterName();
            String group = this.nacosDiscoveryProperties.getGroup();
            DynamicServerListLoadBalancer loadBalancer = (DynamicServerListLoadBalancer)this.getLoadBalancer();
            String name = loadBalancer.getName();
            NamingService namingService = this.nacosServiceManager.getNamingService();
            List<Instance> instances = namingService.selectInstances(name, group, true);
            if (CollectionUtils.isEmpty((Collection)instances)) {
                LOGGER.warn("no instance in service {}", (Object)name);
                return null;
            }
            List<Object> instancesToChoose = instances = this.filterInstanceByIpType(instances);
            if (StringUtils.isNotBlank((CharSequence)clusterName)) {
                List sameClusterInstances = instances.stream().filter(instance -> Objects.equals(clusterName, instance.getClusterName())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(sameClusterInstances)) {
                    instancesToChoose = sameClusterInstances;
                } else {
                    LOGGER.warn("A cross-cluster call occurs\uff0cname = {}, clusterName = {}, instance = {}", new Object[]{name, clusterName, instances});
                }
            }
            Instance instance2 = ExtendBalancer.getHostByRandomWeight2(instancesToChoose);
            if (StringUtils.isNotEmpty((CharSequence)this.ipv6)) {
                this.convertIPv4ToIPv6(instance2);
            }
            return new NacosServer(instance2);
        }
        catch (Exception e) {
            LOGGER.warn("NacosRule error", (Throwable)e);
            return null;
        }
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
    }

    private String getAppLocalIPv6Address() {
        return this.inetIPv6Utils.findIPv6Address();
    }

    private List<Instance> filterInstanceByIpType(List<Instance> instances) {
        if (StringUtils.isNotEmpty((CharSequence)this.ipv6)) {
            ArrayList<Instance> ipv6InstanceList = new ArrayList<Instance>();
            for (Instance instance2 : instances) {
                if (Pattern.matches(IPV4_REGEX, instance2.getIp())) {
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)instance2.getMetadata().get(IPV6_KEY)))) continue;
                    ipv6InstanceList.add(instance2);
                    continue;
                }
                ipv6InstanceList.add(instance2);
            }
            if (ipv6InstanceList.size() == 0) {
                return instances.stream().filter(instance -> Pattern.matches(IPV4_REGEX, instance.getIp())).collect(Collectors.toList());
            }
            return ipv6InstanceList;
        }
        return instances.stream().filter(instance -> Pattern.matches(IPV4_REGEX, instance.getIp())).collect(Collectors.toList());
    }

    private void convertIPv4ToIPv6(Instance instance) {
        String ip;
        if (Pattern.matches(IPV4_REGEX, instance.getIp()) && StringUtils.isNotEmpty((CharSequence)(ip = (String)instance.getMetadata().get(IPV6_KEY)))) {
            instance.setIp(ip);
        }
    }
}

