/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.write.metadata.holder;

import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.IoUtils;
import com.alibaba.excel.write.metadata.WriteWorkbook;
import com.alibaba.excel.write.metadata.holder.AbstractWriteHolder;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;

public class WriteWorkbookHolder
extends AbstractWriteHolder {
    private Workbook workbook;
    private Workbook cachedWorkbook;
    private WriteWorkbook writeWorkbook;
    private File file;
    private OutputStream outputStream;
    private InputStream templateInputStream;
    private File templateFile;
    private InputStream tempTemplateInputStream;
    private Boolean autoCloseStream;
    private ExcelTypeEnum excelType;
    private Boolean mandatoryUseInputStream;
    private Map<Integer, WriteSheetHolder> hasBeenInitializedSheet;
    private String password;
    private Boolean inMemory;
    private Boolean writeExcelOnException;

    public WriteWorkbookHolder(WriteWorkbook writeWorkbook) {
        super(writeWorkbook, null, writeWorkbook.getConvertAllFiled());
        this.writeWorkbook = writeWorkbook;
        this.file = writeWorkbook.getFile();
        if (this.file != null) {
            try {
                this.outputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ExcelGenerateException("Can not found file.", e);
            }
        } else {
            this.outputStream = writeWorkbook.getOutputStream();
        }
        this.autoCloseStream = writeWorkbook.getAutoCloseStream() == null ? Boolean.TRUE : writeWorkbook.getAutoCloseStream();
        try {
            this.copyTemplate();
        }
        catch (IOException e) {
            throw new ExcelGenerateException("Copy template failure.", e);
        }
        if (writeWorkbook.getExcelType() == null) {
            boolean isXls;
            boolean bl = isXls = this.file != null && this.file.getName().endsWith(ExcelTypeEnum.XLS.getValue()) || writeWorkbook.getTemplateFile() != null && writeWorkbook.getTemplateFile().getName().endsWith(ExcelTypeEnum.XLS.getValue());
            this.excelType = isXls ? ExcelTypeEnum.XLS : ExcelTypeEnum.XLSX;
        } else {
            this.excelType = writeWorkbook.getExcelType();
        }
        this.mandatoryUseInputStream = writeWorkbook.getMandatoryUseInputStream() == null ? Boolean.FALSE : writeWorkbook.getMandatoryUseInputStream();
        this.hasBeenInitializedSheet = new HashMap<Integer, WriteSheetHolder>();
        this.password = writeWorkbook.getPassword();
        this.inMemory = writeWorkbook.getInMemory() == null ? Boolean.FALSE : writeWorkbook.getInMemory();
        this.writeExcelOnException = writeWorkbook.getWriteExcelOnException() == null ? Boolean.FALSE : writeWorkbook.getWriteExcelOnException();
    }

    private void copyTemplate() throws IOException {
        if (this.writeWorkbook.getTemplateFile() == null && this.writeWorkbook.getTemplateInputStream() == null) {
            return;
        }
        byte[] templateFileByte = null;
        if (this.writeWorkbook.getTemplateFile() != null) {
            templateFileByte = FileUtils.readFileToByteArray(this.writeWorkbook.getTemplateFile());
        } else if (this.writeWorkbook.getTemplateInputStream() != null) {
            try {
                templateFileByte = IoUtils.toByteArray(this.writeWorkbook.getTemplateInputStream());
            }
            finally {
                if (this.autoCloseStream.booleanValue()) {
                    this.writeWorkbook.getTemplateInputStream().close();
                }
            }
        }
        this.tempTemplateInputStream = new ByteArrayInputStream(templateFileByte);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Workbook getCachedWorkbook() {
        return this.cachedWorkbook;
    }

    public void setCachedWorkbook(Workbook cachedWorkbook) {
        this.cachedWorkbook = cachedWorkbook;
    }

    public Map<Integer, WriteSheetHolder> getHasBeenInitializedSheet() {
        return this.hasBeenInitializedSheet;
    }

    public void setHasBeenInitializedSheet(Map<Integer, WriteSheetHolder> hasBeenInitializedSheet) {
        this.hasBeenInitializedSheet = hasBeenInitializedSheet;
    }

    public WriteWorkbook getWriteWorkbook() {
        return this.writeWorkbook;
    }

    public void setWriteWorkbook(WriteWorkbook writeWorkbook) {
        this.writeWorkbook = writeWorkbook;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public InputStream getTemplateInputStream() {
        return this.templateInputStream;
    }

    public void setTemplateInputStream(InputStream templateInputStream) {
        this.templateInputStream = templateInputStream;
    }

    public InputStream getTempTemplateInputStream() {
        return this.tempTemplateInputStream;
    }

    public void setTempTemplateInputStream(InputStream tempTemplateInputStream) {
        this.tempTemplateInputStream = tempTemplateInputStream;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    public void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public Boolean getAutoCloseStream() {
        return this.autoCloseStream;
    }

    public void setAutoCloseStream(Boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }

    public ExcelTypeEnum getExcelType() {
        return this.excelType;
    }

    public void setExcelType(ExcelTypeEnum excelType) {
        this.excelType = excelType;
    }

    public Boolean getMandatoryUseInputStream() {
        return this.mandatoryUseInputStream;
    }

    public void setMandatoryUseInputStream(Boolean mandatoryUseInputStream) {
        this.mandatoryUseInputStream = mandatoryUseInputStream;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getInMemory() {
        return this.inMemory;
    }

    public void setInMemory(Boolean inMemory) {
        this.inMemory = inMemory;
    }

    public Boolean getWriteExcelOnException() {
        return this.writeExcelOnException;
    }

    public void setWriteExcelOnException(Boolean writeExcelOnException) {
        this.writeExcelOnException = writeExcelOnException;
    }

    @Override
    public HolderEnum holderType() {
        return HolderEnum.WORKBOOK;
    }
}

