/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import com.amashchenko.maven.plugin.gitflow.AbstractGitFlowMojo;
import com.amashchenko.maven.plugin.gitflow.GitFlowVersionInfo;
import java.util.HashMap;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="release", aggregator=true)
public class GitFlowReleaseMojo
extends AbstractGitFlowMojo {
    @Parameter(property="skipTag", defaultValue="false")
    private boolean skipTag = false;
    @Parameter(property="skipTestProject", defaultValue="false")
    private boolean skipTestProject = false;
    @Parameter(property="allowSnapshots", defaultValue="false")
    private boolean allowSnapshots = false;
    @Parameter(property="releaseRebase", defaultValue="false")
    private boolean releaseRebase = false;
    @Parameter(property="releaseMergeNoFF", defaultValue="true")
    private boolean releaseMergeNoFF = true;
    @Parameter(property="pushRemote", defaultValue="true")
    private boolean pushRemote;
    @Parameter(property="releaseVersion", defaultValue="")
    private String releaseVersion = "";
    @Parameter(property="releaseMergeFFOnly", defaultValue="false")
    private boolean releaseMergeFFOnly = false;
    @Parameter(property="digitsOnlyDevVersion", defaultValue="false")
    private boolean digitsOnlyDevVersion = false;
    @Parameter(property="developmentVersion", defaultValue="")
    private String developmentVersion = "";
    @Parameter(property="versionDigitToIncrement")
    private Integer versionDigitToIncrement;
    @Parameter(property="preReleaseGoals")
    private String preReleaseGoals;
    @Parameter(property="postReleaseGoals")
    private String postReleaseGoals;
    @Parameter(property="gpgSignTag", defaultValue="false")
    private boolean gpgSignTag = false;
    @Parameter(property="skipReleaseMergeProdBranch", defaultValue="false")
    private boolean skipReleaseMergeProdBranch = false;
    @Parameter(property="noBackMerge", defaultValue="false")
    private boolean noBackMerge = false;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.validateConfiguration(this.preReleaseGoals, this.postReleaseGoals);
        try {
            String nextSnapshotVersion;
            this.initGitFlowConfig();
            this.checkUncommittedChanges();
            String releaseBranch = this.gitFindBranches(this.gitFlowConfig.getReleaseBranchPrefix(), true);
            if (StringUtils.isNotBlank((String)releaseBranch)) {
                throw new MojoFailureException("Release branch already exists. Cannot start release.");
            }
            if (this.fetchRemote) {
                this.gitFetchRemoteAndCompareCreate(this.gitFlowConfig.getDevelopmentBranch());
                if (this.notSameProdDevName()) {
                    this.gitFetchRemoteAndCompareCreate(this.gitFlowConfig.getProductionBranch());
                }
            }
            this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
            if (!this.allowSnapshots) {
                this.checkSnapshotDependencies();
            }
            if (!this.skipTestProject) {
                this.mvnCleanTest();
            }
            String currentVersion = this.getCurrentProjectVersion();
            String defaultVersion = null;
            defaultVersion = this.tychoBuild ? currentVersion : new GitFlowVersionInfo(currentVersion, this.getVersionPolicy()).getReleaseVersionString();
            if (defaultVersion == null) {
                throw new MojoFailureException("Cannot get default project version.");
            }
            String version = null;
            if (this.settings.isInteractiveMode()) {
                try {
                    while (version == null) {
                        version = this.prompter.prompt("What is release version? [" + defaultVersion + "]");
                        if ("".equals(version) || GitFlowVersionInfo.isValidVersion(version) && this.validBranchName(version)) continue;
                        this.getLog().info((CharSequence)"The version is not valid.");
                        version = null;
                    }
                }
                catch (PrompterException e) {
                    throw new MojoFailureException("release", (Throwable)e);
                }
            } else {
                version = this.releaseVersion;
            }
            if (StringUtils.isBlank((String)version)) {
                this.getLog().info((CharSequence)"Version is blank. Using default version.");
                version = defaultVersion;
            }
            if (StringUtils.isNotBlank((String)this.preReleaseGoals)) {
                this.mvnRun(this.preReleaseGoals);
            }
            HashMap<String, String> messageProperties = new HashMap<String, String>();
            messageProperties.put("version", version);
            if (!version.equals(currentVersion)) {
                this.mvnSetVersions(version);
                this.gitCommit(this.commitMessages.getReleaseStartMessage(), messageProperties);
            }
            if (!this.skipReleaseMergeProdBranch && this.notSameProdDevName()) {
                this.gitCheckout(this.gitFlowConfig.getProductionBranch());
                this.gitMerge(this.gitFlowConfig.getDevelopmentBranch(), this.releaseRebase, this.releaseMergeNoFF, this.releaseMergeFFOnly, this.commitMessages.getReleaseFinishMergeMessage(), messageProperties);
            }
            if (!this.skipTag) {
                if (this.tychoBuild && ArtifactUtils.isSnapshot((String)version)) {
                    version = version.replace("-SNAPSHOT", "");
                }
                messageProperties.put("version", version);
                this.gitTag(this.gitFlowConfig.getVersionTagPrefix() + version, this.commitMessages.getTagReleaseMessage(), this.gpgSignTag, messageProperties);
            }
            if (StringUtils.isNotBlank((String)this.postReleaseGoals)) {
                this.mvnRun(this.postReleaseGoals);
            }
            if (this.notSameProdDevName()) {
                this.gitCheckout(this.gitFlowConfig.getDevelopmentBranch());
                if (!this.noBackMerge) {
                    String refToMerge = !this.skipTag ? this.gitFlowConfig.getVersionTagPrefix() + version : this.gitFlowConfig.getProductionBranch();
                    this.gitMerge(refToMerge, this.releaseRebase, this.releaseMergeNoFF, false, this.commitMessages.getReleaseFinishDevMergeMessage(), messageProperties);
                }
            }
            if (!this.settings.isInteractiveMode() && StringUtils.isNotBlank((String)this.developmentVersion)) {
                nextSnapshotVersion = this.developmentVersion;
            } else {
                GitFlowVersionInfo versionInfo = new GitFlowVersionInfo(version, this.getVersionPolicy());
                if (this.digitsOnlyDevVersion) {
                    versionInfo = versionInfo.digitsVersionInfo();
                }
                nextSnapshotVersion = versionInfo.nextSnapshotVersion(this.versionDigitToIncrement);
            }
            if (StringUtils.isBlank((String)nextSnapshotVersion)) {
                throw new MojoFailureException("Next snapshot version is blank.");
            }
            this.mvnSetVersions(nextSnapshotVersion);
            messageProperties.put("version", nextSnapshotVersion);
            this.gitCommit(this.commitMessages.getReleaseFinishMessage(), messageProperties);
            if (this.installProject) {
                this.mvnCleanInstall();
            }
            if (this.pushRemote) {
                this.gitPush(this.gitFlowConfig.getProductionBranch(), !this.skipTag);
                if (this.notSameProdDevName()) {
                    this.gitPush(this.gitFlowConfig.getDevelopmentBranch(), !this.skipTag);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("release", (Throwable)e);
        }
    }
}

