/*
 * Decompiled with CFR 0.152.
 */
package com.amashchenko.maven.plugin.gitflow;

import java.util.List;
import org.apache.maven.shared.release.policy.PolicyException;
import org.apache.maven.shared.release.policy.version.VersionPolicy;
import org.apache.maven.shared.release.policy.version.VersionPolicyRequest;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.util.StringUtils;

public class GitFlowVersionInfo
extends DefaultVersionInfo {
    private final VersionPolicy versionPolicy;

    public GitFlowVersionInfo(String version, VersionPolicy versionPolicy) throws VersionParseException {
        super(version);
        this.versionPolicy = versionPolicy;
    }

    public GitFlowVersionInfo digitsVersionInfo() throws VersionParseException {
        return new GitFlowVersionInfo(GitFlowVersionInfo.joinDigitString((List)this.getDigits()), this.versionPolicy);
    }

    public static boolean isValidVersion(String version) {
        return StringUtils.isNotBlank((String)version) && (ALTERNATE_PATTERN.matcher(version).matches() || STANDARD_PATTERN.matcher(version).matches());
    }

    public String getReleaseVersionString() {
        if (this.versionPolicy != null) {
            try {
                VersionPolicyRequest request = new VersionPolicyRequest().setVersion(this.toString());
                return this.versionPolicy.getReleaseVersion(request).getVersion();
            }
            catch (PolicyException | VersionParseException ex) {
                throw new RuntimeException("Unable to get release version from policy.", ex);
            }
        }
        return super.getReleaseVersionString();
    }

    public String nextSnapshotVersion() {
        return this.nextSnapshotVersion(null);
    }

    public String nextSnapshotVersion(Integer index) {
        return this.nextVersion(index, true);
    }

    private String nextVersion(Integer index, boolean snapshot) {
        if (this.versionPolicy != null) {
            try {
                VersionPolicyRequest request = new VersionPolicyRequest().setVersion(this.toString());
                if (snapshot) {
                    return this.versionPolicy.getDevelopmentVersion(request).getVersion();
                }
                return this.versionPolicy.getReleaseVersion(request).getVersion();
            }
            catch (PolicyException | VersionParseException ex) {
                throw new RuntimeException("Unable to get development version from policy.", ex);
            }
        }
        List digits = this.getDigits();
        String nextVersion = null;
        if (digits != null) {
            if (index != null && index >= 0 && index < digits.size()) {
                int origDigitsLength = GitFlowVersionInfo.joinDigitString((List)digits).length();
                digits.set(index, this.incrementVersionString((String)digits.get(index)));
                for (int i = index + 1; i < digits.size(); ++i) {
                    digits.set(i, "0");
                }
                String digitsStr = GitFlowVersionInfo.joinDigitString((List)digits);
                nextVersion = digitsStr + (snapshot ? this.getSnapshotVersionString().substring(origDigitsLength) : this.getReleaseVersionString().substring(origDigitsLength));
            } else {
                nextVersion = snapshot ? this.getNextVersion().getSnapshotVersionString() : this.getNextVersion().getReleaseVersionString();
            }
        } else {
            nextVersion = snapshot ? this.getSnapshotVersionString() : this.getReleaseVersionString();
        }
        return nextVersion;
    }

    public String featureVersion(String featureName) {
        String version = this.toString();
        if (featureName != null) {
            version = this.getReleaseVersionString() + "-" + featureName + (this.isSnapshot() ? "-SNAPSHOT" : "");
        }
        return version;
    }

    public String hotfixVersion(boolean preserveSnapshot, Integer index) {
        return this.nextVersion(index, preserveSnapshot && this.isSnapshot());
    }
}

