/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.interfaces.audioplayer.AudioPlayerState;
import com.amazon.ask.model.interfaces.display.DisplayState;
import com.amazon.ask.model.interfaces.system.SystemState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Context {
    @JsonProperty(value="System")
    private SystemState system = null;
    @JsonProperty(value="AudioPlayer")
    private AudioPlayerState audioPlayer = null;
    @JsonProperty(value="Display")
    private DisplayState display = null;

    public static Builder builder() {
        return new Builder();
    }

    private Context(Builder builder) {
        this.system = builder.system;
        this.audioPlayer = builder.audioPlayer;
        this.display = builder.display;
    }

    public SystemState getSystem() {
        return this.system;
    }

    public AudioPlayerState getAudioPlayer() {
        return this.audioPlayer;
    }

    public DisplayState getDisplay() {
        return this.display;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.system, context.system) && Objects.equals(this.audioPlayer, context.audioPlayer) && Objects.equals(this.display, context.display);
    }

    public int hashCode() {
        return Objects.hash(this.system, this.audioPlayer, this.display);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Context {\n");
        sb.append("    system: ").append(this.toIndentedString(this.system)).append("\n");
        sb.append("    audioPlayer: ").append(this.toIndentedString(this.audioPlayer)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private SystemState system;
        private AudioPlayerState audioPlayer;
        private DisplayState display;

        private Builder() {
        }

        @JsonProperty(value="System")
        public Builder withSystem(SystemState system) {
            this.system = system;
            return this;
        }

        @JsonProperty(value="AudioPlayer")
        public Builder withAudioPlayer(AudioPlayerState audioPlayer) {
            this.audioPlayer = audioPlayer;
            return this;
        }

        @JsonProperty(value="Display")
        public Builder withDisplay(DisplayState display) {
            this.display = display;
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

