/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.DialogState;
import com.amazon.ask.model.Intent;
import com.amazon.ask.model.Request;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class IntentRequest
extends Request {
    @JsonProperty(value="dialogState")
    private DialogState dialogState = null;
    @JsonProperty(value="intent")
    private Intent intent = null;

    public static Builder builder() {
        return new Builder();
    }

    private IntentRequest(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "IntentRequest";
        this.requestId = builder.requestId;
        this.timestamp = builder.timestamp;
        this.locale = builder.locale;
        this.dialogState = builder.dialogState;
        this.intent = builder.intent;
    }

    public DialogState getDialogState() {
        return this.dialogState;
    }

    public Intent getIntent() {
        return this.intent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntentRequest intentRequest = (IntentRequest)o;
        return Objects.equals((Object)this.dialogState, (Object)intentRequest.dialogState) && Objects.equals(this.intent, intentRequest.intent) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.dialogState, this.intent, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntentRequest {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    dialogState: ").append(this.toIndentedString((Object)this.dialogState)).append("\n");
        sb.append("    intent: ").append(this.toIndentedString(this.intent)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private DialogState dialogState;
        private Intent intent;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="dialogState")
        public Builder withDialogState(DialogState dialogState) {
            this.dialogState = dialogState;
            return this;
        }

        @JsonProperty(value="intent")
        public Builder withIntent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public IntentRequest build() {
            return new IntentRequest(this);
        }
    }
}

