/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model;

import com.amazon.ask.model.interfaces.audioplayer.AudioPlayerInterface;
import com.amazon.ask.model.interfaces.display.DisplayInterface;
import com.amazon.ask.model.interfaces.videoapp.VideoAppInterface;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class SupportedInterfaces {
    @JsonProperty(value="AudioPlayer")
    private AudioPlayerInterface audioPlayer = null;
    @JsonProperty(value="Display")
    private DisplayInterface display = null;
    @JsonProperty(value="VideoApp")
    private VideoAppInterface videoApp = null;

    public static Builder builder() {
        return new Builder();
    }

    private SupportedInterfaces(Builder builder) {
        this.audioPlayer = builder.audioPlayer;
        this.display = builder.display;
        this.videoApp = builder.videoApp;
    }

    public AudioPlayerInterface getAudioPlayer() {
        return this.audioPlayer;
    }

    public DisplayInterface getDisplay() {
        return this.display;
    }

    public VideoAppInterface getVideoApp() {
        return this.videoApp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportedInterfaces supportedInterfaces = (SupportedInterfaces)o;
        return Objects.equals(this.audioPlayer, supportedInterfaces.audioPlayer) && Objects.equals(this.display, supportedInterfaces.display) && Objects.equals(this.videoApp, supportedInterfaces.videoApp);
    }

    public int hashCode() {
        return Objects.hash(this.audioPlayer, this.display, this.videoApp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupportedInterfaces {\n");
        sb.append("    audioPlayer: ").append(this.toIndentedString(this.audioPlayer)).append("\n");
        sb.append("    display: ").append(this.toIndentedString(this.display)).append("\n");
        sb.append("    videoApp: ").append(this.toIndentedString(this.videoApp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private AudioPlayerInterface audioPlayer;
        private DisplayInterface display;
        private VideoAppInterface videoApp;

        private Builder() {
        }

        @JsonProperty(value="AudioPlayer")
        public Builder withAudioPlayer(AudioPlayerInterface audioPlayer) {
            this.audioPlayer = audioPlayer;
            return this;
        }

        @JsonProperty(value="Display")
        public Builder withDisplay(DisplayInterface display) {
            this.display = display;
            return this;
        }

        @JsonProperty(value="VideoApp")
        public Builder withVideoApp(VideoAppInterface videoApp) {
            this.videoApp = videoApp;
            return this;
        }

        public SupportedInterfaces build() {
            return new SupportedInterfaces(this);
        }
    }
}

