/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.display;

import com.amazon.ask.model.interfaces.display.ImageSize;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class ImageInstance {
    @JsonProperty(value="url")
    private String url = null;
    @JsonProperty(value="size")
    private ImageSize size = null;
    @JsonProperty(value="widthPixels")
    private Integer widthPixels = null;
    @JsonProperty(value="heightPixels")
    private Integer heightPixels = null;

    public static Builder builder() {
        return new Builder();
    }

    private ImageInstance(Builder builder) {
        this.url = builder.url;
        this.size = builder.size;
        this.widthPixels = builder.widthPixels;
        this.heightPixels = builder.heightPixels;
    }

    public String getUrl() {
        return this.url;
    }

    public ImageSize getSize() {
        return this.size;
    }

    public Integer getWidthPixels() {
        return this.widthPixels;
    }

    public Integer getHeightPixels() {
        return this.heightPixels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageInstance interfacesDisplayImageInstance = (ImageInstance)o;
        return Objects.equals(this.url, interfacesDisplayImageInstance.url) && Objects.equals((Object)this.size, (Object)interfacesDisplayImageInstance.size) && Objects.equals(this.widthPixels, interfacesDisplayImageInstance.widthPixels) && Objects.equals(this.heightPixels, interfacesDisplayImageInstance.heightPixels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.size, this.widthPixels, this.heightPixels});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageInstance {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    size: ").append(this.toIndentedString((Object)this.size)).append("\n");
        sb.append("    widthPixels: ").append(this.toIndentedString(this.widthPixels)).append("\n");
        sb.append("    heightPixels: ").append(this.toIndentedString(this.heightPixels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String url;
        private ImageSize size;
        private Integer widthPixels;
        private Integer heightPixels;

        private Builder() {
        }

        @JsonProperty(value="url")
        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        @JsonProperty(value="size")
        public Builder withSize(ImageSize size) {
            this.size = size;
            return this;
        }

        @JsonProperty(value="widthPixels")
        public Builder withWidthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
            return this;
        }

        @JsonProperty(value="heightPixels")
        public Builder withHeightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
            return this;
        }

        public ImageInstance build() {
            return new ImageInstance(this);
        }
    }
}

