/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services;

import com.amazon.ask.model.services.ApiConfiguration;
import com.amazon.ask.model.services.deviceAddress.DeviceAddressServiceClient;
import com.amazon.ask.model.services.directive.DirectiveServiceClient;
import com.amazon.ask.model.services.listManagement.ListManagementServiceClient;

public class ServiceClientFactory {
    private ApiConfiguration defaultApiConfiguration;

    private ServiceClientFactory(ApiConfiguration defaultApiConfiguration) {
        this.defaultApiConfiguration = defaultApiConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DeviceAddressServiceClient getDeviceAddressService() {
        try {
            return new DeviceAddressServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing DeviceAddressServiceClient: " + ex.getMessage(), ex);
        }
    }

    public DirectiveServiceClient getDirectiveService() {
        try {
            return new DirectiveServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing DirectiveServiceClient: " + ex.getMessage(), ex);
        }
    }

    public ListManagementServiceClient getListManagementService() {
        try {
            return new ListManagementServiceClient(this.defaultApiConfiguration);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error while initializing ListManagementServiceClient: " + ex.getMessage(), ex);
        }
    }

    public static final class Builder {
        private ApiConfiguration defaultApiConfiguration;

        private Builder() {
        }

        public Builder withDefaultApiConfiguration(ApiConfiguration defaultApiConfiguration) {
            this.defaultApiConfiguration = defaultApiConfiguration;
            return this;
        }

        public ServiceClientFactory build() {
            return new ServiceClientFactory(this.defaultApiConfiguration);
        }
    }
}

