/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.ListItemState;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AlexaListItem {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="version")
    private Long version = null;
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="status")
    private ListItemState status = null;
    @JsonProperty(value="createdTime")
    private String createdTime = null;
    @JsonProperty(value="updatedTime")
    private String updatedTime = null;
    @JsonProperty(value="href")
    private String href = null;

    public static Builder builder() {
        return new Builder();
    }

    private AlexaListItem(Builder builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.value = builder.value;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
        this.href = builder.href;
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getValue() {
        return this.value;
    }

    public ListItemState getStatus() {
        return this.status;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getUpdatedTime() {
        return this.updatedTime;
    }

    public String getHref() {
        return this.href;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlexaListItem servicesListManagementAlexaListItem = (AlexaListItem)o;
        return Objects.equals(this.id, servicesListManagementAlexaListItem.id) && Objects.equals(this.version, servicesListManagementAlexaListItem.version) && Objects.equals(this.value, servicesListManagementAlexaListItem.value) && Objects.equals((Object)this.status, (Object)servicesListManagementAlexaListItem.status) && Objects.equals(this.createdTime, servicesListManagementAlexaListItem.createdTime) && Objects.equals(this.updatedTime, servicesListManagementAlexaListItem.updatedTime) && Objects.equals(this.href, servicesListManagementAlexaListItem.href);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.value, this.status, this.createdTime, this.updatedTime, this.href});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlexaListItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    createdTime: ").append(this.toIndentedString(this.createdTime)).append("\n");
        sb.append("    updatedTime: ").append(this.toIndentedString(this.updatedTime)).append("\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String id;
        private Long version;
        private String value;
        private ListItemState status;
        private String createdTime;
        private String updatedTime;
        private String href;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="value")
        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(ListItemState status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="createdTime")
        public Builder withCreatedTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonProperty(value="updatedTime")
        public Builder withUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @JsonProperty(value="href")
        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public AlexaListItem build() {
            return new AlexaListItem(this);
        }
    }
}

