/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.services.listManagement;

import com.amazon.ask.model.services.listManagement.ListState;
import com.amazon.ask.model.services.listManagement.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class AlexaListMetadata {
    @JsonProperty(value="listId")
    private String listId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="state")
    private ListState state = null;
    @JsonProperty(value="version")
    private Long version = null;
    @JsonProperty(value="statusMap")
    private List<Status> statusMap = new ArrayList<Status>();

    public static Builder builder() {
        return new Builder();
    }

    private AlexaListMetadata(Builder builder) {
        this.listId = builder.listId;
        this.name = builder.name;
        this.state = builder.state;
        this.version = builder.version;
        this.statusMap = builder.statusMap;
    }

    public String getListId() {
        return this.listId;
    }

    public String getName() {
        return this.name;
    }

    public ListState getState() {
        return this.state;
    }

    public Long getVersion() {
        return this.version;
    }

    public List<Status> getStatusMap() {
        return this.statusMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlexaListMetadata servicesListManagementAlexaListMetadata = (AlexaListMetadata)o;
        return Objects.equals(this.listId, servicesListManagementAlexaListMetadata.listId) && Objects.equals(this.name, servicesListManagementAlexaListMetadata.name) && Objects.equals((Object)this.state, (Object)servicesListManagementAlexaListMetadata.state) && Objects.equals(this.version, servicesListManagementAlexaListMetadata.version) && Objects.equals(this.statusMap, servicesListManagementAlexaListMetadata.statusMap);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.listId, this.name, this.state, this.version, this.statusMap});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlexaListMetadata {\n");
        sb.append("    listId: ").append(this.toIndentedString(this.listId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    statusMap: ").append(this.toIndentedString(this.statusMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String listId;
        private String name;
        private ListState state;
        private Long version;
        private List<Status> statusMap;

        private Builder() {
        }

        @JsonProperty(value="listId")
        public Builder withListId(String listId) {
            this.listId = listId;
            return this;
        }

        @JsonProperty(value="name")
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="state")
        public Builder withState(ListState state) {
            this.state = state;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="statusMap")
        public Builder withStatusMap(List<Status> statusMap) {
            this.statusMap = statusMap;
            return this;
        }

        public Builder addStatusMapItem(Status statusMapItem) {
            if (this.statusMap == null) {
                this.statusMap = new ArrayList<Status>();
            }
            this.statusMap.add(statusMapItem);
            return this;
        }

        public AlexaListMetadata build() {
            return new AlexaListMetadata(this);
        }
    }
}

