/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.ui;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class Image {
    @JsonProperty(value="smallImageUrl")
    private String smallImageUrl = null;
    @JsonProperty(value="largeImageUrl")
    private String largeImageUrl = null;

    public static Builder builder() {
        return new Builder();
    }

    private Image(Builder builder) {
        this.smallImageUrl = builder.smallImageUrl;
        this.largeImageUrl = builder.largeImageUrl;
    }

    public String getSmallImageUrl() {
        return this.smallImageUrl;
    }

    public String getLargeImageUrl() {
        return this.largeImageUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Image uiImage = (Image)o;
        return Objects.equals(this.smallImageUrl, uiImage.smallImageUrl) && Objects.equals(this.largeImageUrl, uiImage.largeImageUrl);
    }

    public int hashCode() {
        return Objects.hash(this.smallImageUrl, this.largeImageUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Image {\n");
        sb.append("    smallImageUrl: ").append(this.toIndentedString(this.smallImageUrl)).append("\n");
        sb.append("    largeImageUrl: ").append(this.toIndentedString(this.largeImageUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String smallImageUrl;
        private String largeImageUrl;

        private Builder() {
        }

        @JsonProperty(value="smallImageUrl")
        public Builder withSmallImageUrl(String smallImageUrl) {
            this.smallImageUrl = smallImageUrl;
            return this;
        }

        @JsonProperty(value="largeImageUrl")
        public Builder withLargeImageUrl(String largeImageUrl) {
            this.largeImageUrl = largeImageUrl;
            return this;
        }

        public Image build() {
            return new Image(this);
        }
    }
}

