/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.amplifybackend;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.amplifybackend.AWSAmplifyBackend;
import com.amazonaws.services.amplifybackend.AWSAmplifyBackendClientBuilder;
import com.amazonaws.services.amplifybackend.model.AWSAmplifyBackendException;
import com.amazonaws.services.amplifybackend.model.CloneBackendRequest;
import com.amazonaws.services.amplifybackend.model.CloneBackendResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendConfigRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendConfigResult;
import com.amazonaws.services.amplifybackend.model.CreateBackendRequest;
import com.amazonaws.services.amplifybackend.model.CreateBackendResult;
import com.amazonaws.services.amplifybackend.model.CreateTokenRequest;
import com.amazonaws.services.amplifybackend.model.CreateTokenResult;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.DeleteBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.DeleteBackendRequest;
import com.amazonaws.services.amplifybackend.model.DeleteBackendResult;
import com.amazonaws.services.amplifybackend.model.DeleteTokenRequest;
import com.amazonaws.services.amplifybackend.model.DeleteTokenResult;
import com.amazonaws.services.amplifybackend.model.GenerateBackendAPIModelsRequest;
import com.amazonaws.services.amplifybackend.model.GenerateBackendAPIModelsResult;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIModelsRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIModelsResult;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.GetBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.GetBackendJobRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendJobResult;
import com.amazonaws.services.amplifybackend.model.GetBackendRequest;
import com.amazonaws.services.amplifybackend.model.GetBackendResult;
import com.amazonaws.services.amplifybackend.model.GetTokenRequest;
import com.amazonaws.services.amplifybackend.model.GetTokenResult;
import com.amazonaws.services.amplifybackend.model.ListBackendJobsRequest;
import com.amazonaws.services.amplifybackend.model.ListBackendJobsResult;
import com.amazonaws.services.amplifybackend.model.RemoveAllBackendsRequest;
import com.amazonaws.services.amplifybackend.model.RemoveAllBackendsResult;
import com.amazonaws.services.amplifybackend.model.RemoveBackendConfigRequest;
import com.amazonaws.services.amplifybackend.model.RemoveBackendConfigResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAPIRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAPIResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAuthRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendAuthResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendConfigRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendConfigResult;
import com.amazonaws.services.amplifybackend.model.UpdateBackendJobRequest;
import com.amazonaws.services.amplifybackend.model.UpdateBackendJobResult;
import com.amazonaws.services.amplifybackend.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CloneBackendRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CloneBackendResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendAPIRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendAPIResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendAuthRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendAuthResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendConfigRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendConfigResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateBackendResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateTokenRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.CreateTokenResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteBackendAPIRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteBackendAPIResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteBackendAuthRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteBackendAuthResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteBackendRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteBackendResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteTokenRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.DeleteTokenResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GatewayTimeoutExceptionUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GenerateBackendAPIModelsRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GenerateBackendAPIModelsResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendAPIModelsRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendAPIModelsResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendAPIRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendAPIResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendAuthRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendAuthResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendJobRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendJobResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetBackendResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetTokenRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.GetTokenResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.ListBackendJobsRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.ListBackendJobsResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.RemoveAllBackendsRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.RemoveAllBackendsResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.RemoveBackendConfigRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.RemoveBackendConfigResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.TooManyRequestsExceptionUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendAPIRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendAPIResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendAuthRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendAuthResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendConfigRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendConfigResultJsonUnmarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendJobRequestProtocolMarshaller;
import com.amazonaws.services.amplifybackend.model.transform.UpdateBackendJobResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSAmplifyBackendClient
extends AmazonWebServiceClient
implements AWSAmplifyBackend {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSAmplifyBackend.class);
    private static final String DEFAULT_SIGNING_NAME = "amplifybackend";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("GatewayTimeoutException").withExceptionUnmarshaller((JsonErrorUnmarshaller)GatewayTimeoutExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyRequestsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSAmplifyBackendException.class));

    public static AWSAmplifyBackendClientBuilder builder() {
        return AWSAmplifyBackendClientBuilder.standard();
    }

    AWSAmplifyBackendClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSAmplifyBackendClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("amplifybackend.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/amplifybackend/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/amplifybackend/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CloneBackendResult cloneBackend(CloneBackendRequest request) {
        request = (CloneBackendRequest)this.beforeClientExecution(request);
        return this.executeCloneBackend(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CloneBackendResult executeCloneBackend(CloneBackendRequest cloneBackendRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cloneBackendRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CloneBackendRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CloneBackendRequestProtocolMarshaller(protocolFactory).marshall((CloneBackendRequest)super.beforeMarshalling((AmazonWebServiceRequest)cloneBackendRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CloneBackend");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CloneBackendResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CloneBackendResult cloneBackendResult = (CloneBackendResult)response.getAwsResponse();
            return cloneBackendResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackendResult createBackend(CreateBackendRequest request) {
        request = (CreateBackendRequest)this.beforeClientExecution(request);
        return this.executeCreateBackend(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackendResult executeCreateBackend(CreateBackendRequest createBackendRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackendRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackendRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackendRequestProtocolMarshaller(protocolFactory).marshall((CreateBackendRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBackendRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBackend");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackendResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackendResult createBackendResult = (CreateBackendResult)response.getAwsResponse();
            return createBackendResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackendAPIResult createBackendAPI(CreateBackendAPIRequest request) {
        request = (CreateBackendAPIRequest)this.beforeClientExecution(request);
        return this.executeCreateBackendAPI(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackendAPIResult executeCreateBackendAPI(CreateBackendAPIRequest createBackendAPIRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackendAPIRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackendAPIRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackendAPIRequestProtocolMarshaller(protocolFactory).marshall((CreateBackendAPIRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBackendAPIRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBackendAPI");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackendAPIResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackendAPIResult createBackendAPIResult = (CreateBackendAPIResult)response.getAwsResponse();
            return createBackendAPIResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackendAuthResult createBackendAuth(CreateBackendAuthRequest request) {
        request = (CreateBackendAuthRequest)this.beforeClientExecution(request);
        return this.executeCreateBackendAuth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackendAuthResult executeCreateBackendAuth(CreateBackendAuthRequest createBackendAuthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackendAuthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackendAuthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackendAuthRequestProtocolMarshaller(protocolFactory).marshall((CreateBackendAuthRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBackendAuthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBackendAuth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackendAuthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackendAuthResult createBackendAuthResult = (CreateBackendAuthResult)response.getAwsResponse();
            return createBackendAuthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateBackendConfigResult createBackendConfig(CreateBackendConfigRequest request) {
        request = (CreateBackendConfigRequest)this.beforeClientExecution(request);
        return this.executeCreateBackendConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateBackendConfigResult executeCreateBackendConfig(CreateBackendConfigRequest createBackendConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackendConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackendConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackendConfigRequestProtocolMarshaller(protocolFactory).marshall((CreateBackendConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBackendConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateBackendConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackendConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackendConfigResult createBackendConfigResult = (CreateBackendConfigResult)response.getAwsResponse();
            return createBackendConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTokenResult createToken(CreateTokenRequest request) {
        request = (CreateTokenRequest)this.beforeClientExecution(request);
        return this.executeCreateToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTokenResult executeCreateToken(CreateTokenRequest createTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTokenRequestProtocolMarshaller(protocolFactory).marshall((CreateTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTokenResult createTokenResult = (CreateTokenResult)response.getAwsResponse();
            return createTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackendResult deleteBackend(DeleteBackendRequest request) {
        request = (DeleteBackendRequest)this.beforeClientExecution(request);
        return this.executeDeleteBackend(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackendResult executeDeleteBackend(DeleteBackendRequest deleteBackendRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackendRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackendRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackendRequestProtocolMarshaller(protocolFactory).marshall((DeleteBackendRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBackendRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBackend");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackendResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackendResult deleteBackendResult = (DeleteBackendResult)response.getAwsResponse();
            return deleteBackendResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackendAPIResult deleteBackendAPI(DeleteBackendAPIRequest request) {
        request = (DeleteBackendAPIRequest)this.beforeClientExecution(request);
        return this.executeDeleteBackendAPI(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackendAPIResult executeDeleteBackendAPI(DeleteBackendAPIRequest deleteBackendAPIRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackendAPIRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackendAPIRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackendAPIRequestProtocolMarshaller(protocolFactory).marshall((DeleteBackendAPIRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBackendAPIRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBackendAPI");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackendAPIResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackendAPIResult deleteBackendAPIResult = (DeleteBackendAPIResult)response.getAwsResponse();
            return deleteBackendAPIResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteBackendAuthResult deleteBackendAuth(DeleteBackendAuthRequest request) {
        request = (DeleteBackendAuthRequest)this.beforeClientExecution(request);
        return this.executeDeleteBackendAuth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteBackendAuthResult executeDeleteBackendAuth(DeleteBackendAuthRequest deleteBackendAuthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackendAuthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackendAuthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackendAuthRequestProtocolMarshaller(protocolFactory).marshall((DeleteBackendAuthRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBackendAuthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBackendAuth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackendAuthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackendAuthResult deleteBackendAuthResult = (DeleteBackendAuthResult)response.getAwsResponse();
            return deleteBackendAuthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTokenResult deleteToken(DeleteTokenRequest request) {
        request = (DeleteTokenRequest)this.beforeClientExecution(request);
        return this.executeDeleteToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTokenResult executeDeleteToken(DeleteTokenRequest deleteTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTokenRequestProtocolMarshaller(protocolFactory).marshall((DeleteTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTokenResult deleteTokenResult = (DeleteTokenResult)response.getAwsResponse();
            return deleteTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GenerateBackendAPIModelsResult generateBackendAPIModels(GenerateBackendAPIModelsRequest request) {
        request = (GenerateBackendAPIModelsRequest)this.beforeClientExecution(request);
        return this.executeGenerateBackendAPIModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GenerateBackendAPIModelsResult executeGenerateBackendAPIModels(GenerateBackendAPIModelsRequest generateBackendAPIModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(generateBackendAPIModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GenerateBackendAPIModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GenerateBackendAPIModelsRequestProtocolMarshaller(protocolFactory).marshall((GenerateBackendAPIModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)generateBackendAPIModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GenerateBackendAPIModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GenerateBackendAPIModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GenerateBackendAPIModelsResult generateBackendAPIModelsResult = (GenerateBackendAPIModelsResult)response.getAwsResponse();
            return generateBackendAPIModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackendResult getBackend(GetBackendRequest request) {
        request = (GetBackendRequest)this.beforeClientExecution(request);
        return this.executeGetBackend(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackendResult executeGetBackend(GetBackendRequest getBackendRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackendRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackendRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackendRequestProtocolMarshaller(protocolFactory).marshall((GetBackendRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBackendRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBackend");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBackendResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackendResult getBackendResult = (GetBackendResult)response.getAwsResponse();
            return getBackendResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackendAPIResult getBackendAPI(GetBackendAPIRequest request) {
        request = (GetBackendAPIRequest)this.beforeClientExecution(request);
        return this.executeGetBackendAPI(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackendAPIResult executeGetBackendAPI(GetBackendAPIRequest getBackendAPIRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackendAPIRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackendAPIRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackendAPIRequestProtocolMarshaller(protocolFactory).marshall((GetBackendAPIRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBackendAPIRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBackendAPI");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBackendAPIResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackendAPIResult getBackendAPIResult = (GetBackendAPIResult)response.getAwsResponse();
            return getBackendAPIResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackendAPIModelsResult getBackendAPIModels(GetBackendAPIModelsRequest request) {
        request = (GetBackendAPIModelsRequest)this.beforeClientExecution(request);
        return this.executeGetBackendAPIModels(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackendAPIModelsResult executeGetBackendAPIModels(GetBackendAPIModelsRequest getBackendAPIModelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackendAPIModelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackendAPIModelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackendAPIModelsRequestProtocolMarshaller(protocolFactory).marshall((GetBackendAPIModelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBackendAPIModelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBackendAPIModels");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBackendAPIModelsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackendAPIModelsResult getBackendAPIModelsResult = (GetBackendAPIModelsResult)response.getAwsResponse();
            return getBackendAPIModelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackendAuthResult getBackendAuth(GetBackendAuthRequest request) {
        request = (GetBackendAuthRequest)this.beforeClientExecution(request);
        return this.executeGetBackendAuth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackendAuthResult executeGetBackendAuth(GetBackendAuthRequest getBackendAuthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackendAuthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackendAuthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackendAuthRequestProtocolMarshaller(protocolFactory).marshall((GetBackendAuthRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBackendAuthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBackendAuth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBackendAuthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackendAuthResult getBackendAuthResult = (GetBackendAuthResult)response.getAwsResponse();
            return getBackendAuthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetBackendJobResult getBackendJob(GetBackendJobRequest request) {
        request = (GetBackendJobRequest)this.beforeClientExecution(request);
        return this.executeGetBackendJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetBackendJobResult executeGetBackendJob(GetBackendJobRequest getBackendJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getBackendJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetBackendJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetBackendJobRequestProtocolMarshaller(protocolFactory).marshall((GetBackendJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getBackendJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBackendJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetBackendJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetBackendJobResult getBackendJobResult = (GetBackendJobResult)response.getAwsResponse();
            return getBackendJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTokenResult getToken(GetTokenRequest request) {
        request = (GetTokenRequest)this.beforeClientExecution(request);
        return this.executeGetToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTokenResult executeGetToken(GetTokenRequest getTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTokenRequestProtocolMarshaller(protocolFactory).marshall((GetTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetToken");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTokenResult getTokenResult = (GetTokenResult)response.getAwsResponse();
            return getTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListBackendJobsResult listBackendJobs(ListBackendJobsRequest request) {
        request = (ListBackendJobsRequest)this.beforeClientExecution(request);
        return this.executeListBackendJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListBackendJobsResult executeListBackendJobs(ListBackendJobsRequest listBackendJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listBackendJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBackendJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBackendJobsRequestProtocolMarshaller(protocolFactory).marshall((ListBackendJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listBackendJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListBackendJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListBackendJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListBackendJobsResult listBackendJobsResult = (ListBackendJobsResult)response.getAwsResponse();
            return listBackendJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveAllBackendsResult removeAllBackends(RemoveAllBackendsRequest request) {
        request = (RemoveAllBackendsRequest)this.beforeClientExecution(request);
        return this.executeRemoveAllBackends(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveAllBackendsResult executeRemoveAllBackends(RemoveAllBackendsRequest removeAllBackendsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeAllBackendsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveAllBackendsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveAllBackendsRequestProtocolMarshaller(protocolFactory).marshall((RemoveAllBackendsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeAllBackendsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveAllBackends");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveAllBackendsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveAllBackendsResult removeAllBackendsResult = (RemoveAllBackendsResult)response.getAwsResponse();
            return removeAllBackendsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveBackendConfigResult removeBackendConfig(RemoveBackendConfigRequest request) {
        request = (RemoveBackendConfigRequest)this.beforeClientExecution(request);
        return this.executeRemoveBackendConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveBackendConfigResult executeRemoveBackendConfig(RemoveBackendConfigRequest removeBackendConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeBackendConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveBackendConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveBackendConfigRequestProtocolMarshaller(protocolFactory).marshall((RemoveBackendConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeBackendConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveBackendConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveBackendConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveBackendConfigResult removeBackendConfigResult = (RemoveBackendConfigResult)response.getAwsResponse();
            return removeBackendConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBackendAPIResult updateBackendAPI(UpdateBackendAPIRequest request) {
        request = (UpdateBackendAPIRequest)this.beforeClientExecution(request);
        return this.executeUpdateBackendAPI(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBackendAPIResult executeUpdateBackendAPI(UpdateBackendAPIRequest updateBackendAPIRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBackendAPIRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBackendAPIRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBackendAPIRequestProtocolMarshaller(protocolFactory).marshall((UpdateBackendAPIRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBackendAPIRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBackendAPI");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBackendAPIResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBackendAPIResult updateBackendAPIResult = (UpdateBackendAPIResult)response.getAwsResponse();
            return updateBackendAPIResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBackendAuthResult updateBackendAuth(UpdateBackendAuthRequest request) {
        request = (UpdateBackendAuthRequest)this.beforeClientExecution(request);
        return this.executeUpdateBackendAuth(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBackendAuthResult executeUpdateBackendAuth(UpdateBackendAuthRequest updateBackendAuthRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBackendAuthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBackendAuthRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBackendAuthRequestProtocolMarshaller(protocolFactory).marshall((UpdateBackendAuthRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBackendAuthRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBackendAuth");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBackendAuthResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBackendAuthResult updateBackendAuthResult = (UpdateBackendAuthResult)response.getAwsResponse();
            return updateBackendAuthResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBackendConfigResult updateBackendConfig(UpdateBackendConfigRequest request) {
        request = (UpdateBackendConfigRequest)this.beforeClientExecution(request);
        return this.executeUpdateBackendConfig(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBackendConfigResult executeUpdateBackendConfig(UpdateBackendConfigRequest updateBackendConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBackendConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBackendConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBackendConfigRequestProtocolMarshaller(protocolFactory).marshall((UpdateBackendConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBackendConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBackendConfig");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBackendConfigResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBackendConfigResult updateBackendConfigResult = (UpdateBackendConfigResult)response.getAwsResponse();
            return updateBackendConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateBackendJobResult updateBackendJob(UpdateBackendJobRequest request) {
        request = (UpdateBackendJobRequest)this.beforeClientExecution(request);
        return this.executeUpdateBackendJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateBackendJobResult executeUpdateBackendJob(UpdateBackendJobRequest updateBackendJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateBackendJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateBackendJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateBackendJobRequestProtocolMarshaller(protocolFactory).marshall((UpdateBackendJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateBackendJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"AmplifyBackend");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateBackendJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateBackendJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateBackendJobResult updateBackendJobResult = (UpdateBackendJobResult)response.getAwsResponse();
            return updateBackendJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

