/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class LaunchSpecification
implements Serializable,
Cloneable {
    private String userData;
    private String addressingType;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private Boolean ebsOptimized;
    private IamInstanceProfileSpecification iamInstanceProfile;
    private String imageId;
    private String instanceType;
    private String kernelId;
    private String keyName;
    private SdkInternalList<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private SpotPlacement placement;
    private String ramdiskId;
    private String subnetId;
    private SdkInternalList<GroupIdentifier> allSecurityGroups;
    private Boolean monitoringEnabled;
    private SdkInternalList<String> securityGroups;

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public String getUserData() {
        return this.userData;
    }

    public LaunchSpecification withUserData(String userData) {
        this.setUserData(userData);
        return this;
    }

    public void setAddressingType(String addressingType) {
        this.addressingType = addressingType;
    }

    public String getAddressingType() {
        return this.addressingType;
    }

    public LaunchSpecification withAddressingType(String addressingType) {
        this.setAddressingType(addressingType);
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings);
    }

    public LaunchSpecification withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public LaunchSpecification withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public LaunchSpecification withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public IamInstanceProfileSpecification getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public LaunchSpecification withIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.setIamInstanceProfile(iamInstanceProfile);
        return this;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public LaunchSpecification withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    @JsonProperty(value="instanceType")
    public String getInstanceType() {
        return this.instanceType;
    }

    public LaunchSpecification withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    @JsonIgnore
    public void setInstanceType(InstanceType instanceType) {
        this.withInstanceType(instanceType);
    }

    public LaunchSpecification withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public LaunchSpecification withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public LaunchSpecification withKeyName(String keyName) {
        this.setKeyName(keyName);
        return this;
    }

    public List<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new SdkInternalList();
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        this.networkInterfaces = new SdkInternalList<InstanceNetworkInterfaceSpecification>(networkInterfaces);
    }

    public LaunchSpecification withNetworkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
        if (this.networkInterfaces == null) {
            this.setNetworkInterfaces(new SdkInternalList<InstanceNetworkInterfaceSpecification>(networkInterfaces.length));
        }
        for (InstanceNetworkInterfaceSpecification ele : networkInterfaces) {
            this.networkInterfaces.add(ele);
        }
        return this;
    }

    public LaunchSpecification withNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        this.setNetworkInterfaces(networkInterfaces);
        return this;
    }

    public void setPlacement(SpotPlacement placement) {
        this.placement = placement;
    }

    public SpotPlacement getPlacement() {
        return this.placement;
    }

    public LaunchSpecification withPlacement(SpotPlacement placement) {
        this.setPlacement(placement);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public LaunchSpecification withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public LaunchSpecification withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public List<GroupIdentifier> getAllSecurityGroups() {
        if (this.allSecurityGroups == null) {
            this.allSecurityGroups = new SdkInternalList();
        }
        return this.allSecurityGroups;
    }

    public void setAllSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
        if (allSecurityGroups == null) {
            this.allSecurityGroups = null;
            return;
        }
        this.allSecurityGroups = new SdkInternalList<GroupIdentifier>(allSecurityGroups);
    }

    public LaunchSpecification withAllSecurityGroups(GroupIdentifier ... allSecurityGroups) {
        if (this.allSecurityGroups == null) {
            this.setAllSecurityGroups(new SdkInternalList<GroupIdentifier>(allSecurityGroups.length));
        }
        for (GroupIdentifier ele : allSecurityGroups) {
            this.allSecurityGroups.add(ele);
        }
        return this;
    }

    public LaunchSpecification withAllSecurityGroups(Collection<GroupIdentifier> allSecurityGroups) {
        this.setAllSecurityGroups(allSecurityGroups);
        return this;
    }

    public void setMonitoringEnabled(Boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    public Boolean getMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public LaunchSpecification withMonitoringEnabled(Boolean monitoringEnabled) {
        this.setMonitoringEnabled(monitoringEnabled);
        return this;
    }

    public Boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new SdkInternalList();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        this.securityGroups = new SdkInternalList<String>(securityGroups);
    }

    public LaunchSpecification withSecurityGroups(String ... securityGroups) {
        if (this.securityGroups == null) {
            this.setSecurityGroups(new SdkInternalList<String>(securityGroups.length));
        }
        for (String ele : securityGroups) {
            this.securityGroups.add(ele);
        }
        return this;
    }

    public LaunchSpecification withSecurityGroups(Collection<String> securityGroups) {
        this.setSecurityGroups(securityGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserData() != null) {
            sb.append("UserData: ").append(this.getUserData()).append(",");
        }
        if (this.getAddressingType() != null) {
            sb.append("AddressingType: ").append(this.getAddressingType()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: ").append(this.getIamInstanceProfile()).append(",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: ").append(this.getKeyName()).append(",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: ").append(this.getNetworkInterfaces()).append(",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: ").append(this.getPlacement()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getAllSecurityGroups() != null) {
            sb.append("AllSecurityGroups: ").append(this.getAllSecurityGroups()).append(",");
        }
        if (this.getMonitoringEnabled() != null) {
            sb.append("MonitoringEnabled: ").append(this.getMonitoringEnabled()).append(",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: ").append(this.getSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchSpecification)) {
            return false;
        }
        LaunchSpecification other = (LaunchSpecification)obj;
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getAddressingType() == null ^ this.getAddressingType() == null) {
            return false;
        }
        if (other.getAddressingType() != null && !other.getAddressingType().equals(this.getAddressingType())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getAllSecurityGroups() == null ^ this.getAllSecurityGroups() == null) {
            return false;
        }
        if (other.getAllSecurityGroups() != null && !other.getAllSecurityGroups().equals(this.getAllSecurityGroups())) {
            return false;
        }
        if (other.getMonitoringEnabled() == null ^ this.getMonitoringEnabled() == null) {
            return false;
        }
        if (other.getMonitoringEnabled() != null && !other.getMonitoringEnabled().equals(this.getMonitoringEnabled())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        return other.getSecurityGroups() == null || other.getSecurityGroups().equals(this.getSecurityGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getAddressingType() == null ? 0 : this.getAddressingType().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getAllSecurityGroups() == null ? 0 : this.getAllSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringEnabled() == null ? 0 : this.getMonitoringEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        return hashCode;
    }

    public LaunchSpecification clone() {
        try {
            return (LaunchSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

