/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Category;
import com.amazonaws.services.eks.model.InsightCategorySpecificSummary;
import com.amazonaws.services.eks.model.InsightResourceDetail;
import com.amazonaws.services.eks.model.InsightStatus;
import com.amazonaws.services.eks.model.transform.InsightMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Insight
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String name;
    private String category;
    private String kubernetesVersion;
    private Date lastRefreshTime;
    private Date lastTransitionTime;
    private String description;
    private InsightStatus insightStatus;
    private String recommendation;
    private Map<String, String> additionalInfo;
    private List<InsightResourceDetail> resources;
    private InsightCategorySpecificSummary categorySpecificSummary;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Insight withId(String id) {
        this.setId(id);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Insight withName(String name) {
        this.setName(name);
        return this;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public Insight withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public Insight withCategory(Category category) {
        this.category = category.toString();
        return this;
    }

    public void setKubernetesVersion(String kubernetesVersion) {
        this.kubernetesVersion = kubernetesVersion;
    }

    public String getKubernetesVersion() {
        return this.kubernetesVersion;
    }

    public Insight withKubernetesVersion(String kubernetesVersion) {
        this.setKubernetesVersion(kubernetesVersion);
        return this;
    }

    public void setLastRefreshTime(Date lastRefreshTime) {
        this.lastRefreshTime = lastRefreshTime;
    }

    public Date getLastRefreshTime() {
        return this.lastRefreshTime;
    }

    public Insight withLastRefreshTime(Date lastRefreshTime) {
        this.setLastRefreshTime(lastRefreshTime);
        return this;
    }

    public void setLastTransitionTime(Date lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public Date getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public Insight withLastTransitionTime(Date lastTransitionTime) {
        this.setLastTransitionTime(lastTransitionTime);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Insight withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setInsightStatus(InsightStatus insightStatus) {
        this.insightStatus = insightStatus;
    }

    public InsightStatus getInsightStatus() {
        return this.insightStatus;
    }

    public Insight withInsightStatus(InsightStatus insightStatus) {
        this.setInsightStatus(insightStatus);
        return this;
    }

    public void setRecommendation(String recommendation) {
        this.recommendation = recommendation;
    }

    public String getRecommendation() {
        return this.recommendation;
    }

    public Insight withRecommendation(String recommendation) {
        this.setRecommendation(recommendation);
        return this;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public Insight withAdditionalInfo(Map<String, String> additionalInfo) {
        this.setAdditionalInfo(additionalInfo);
        return this;
    }

    public Insight addAdditionalInfoEntry(String key, String value) {
        if (null == this.additionalInfo) {
            this.additionalInfo = new HashMap<String, String>();
        }
        if (this.additionalInfo.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalInfo.put(key, value);
        return this;
    }

    public Insight clearAdditionalInfoEntries() {
        this.additionalInfo = null;
        return this;
    }

    public List<InsightResourceDetail> getResources() {
        return this.resources;
    }

    public void setResources(Collection<InsightResourceDetail> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<InsightResourceDetail>(resources);
    }

    public Insight withResources(InsightResourceDetail ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<InsightResourceDetail>(resources.length));
        }
        for (InsightResourceDetail ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public Insight withResources(Collection<InsightResourceDetail> resources) {
        this.setResources(resources);
        return this;
    }

    public void setCategorySpecificSummary(InsightCategorySpecificSummary categorySpecificSummary) {
        this.categorySpecificSummary = categorySpecificSummary;
    }

    public InsightCategorySpecificSummary getCategorySpecificSummary() {
        return this.categorySpecificSummary;
    }

    public Insight withCategorySpecificSummary(InsightCategorySpecificSummary categorySpecificSummary) {
        this.setCategorySpecificSummary(categorySpecificSummary);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getKubernetesVersion() != null) {
            sb.append("KubernetesVersion: ").append(this.getKubernetesVersion()).append(",");
        }
        if (this.getLastRefreshTime() != null) {
            sb.append("LastRefreshTime: ").append(this.getLastRefreshTime()).append(",");
        }
        if (this.getLastTransitionTime() != null) {
            sb.append("LastTransitionTime: ").append(this.getLastTransitionTime()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getInsightStatus() != null) {
            sb.append("InsightStatus: ").append(this.getInsightStatus()).append(",");
        }
        if (this.getRecommendation() != null) {
            sb.append("Recommendation: ").append(this.getRecommendation()).append(",");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(this.getAdditionalInfo()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getCategorySpecificSummary() != null) {
            sb.append("CategorySpecificSummary: ").append(this.getCategorySpecificSummary());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Insight)) {
            return false;
        }
        Insight other = (Insight)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getKubernetesVersion() == null ^ this.getKubernetesVersion() == null) {
            return false;
        }
        if (other.getKubernetesVersion() != null && !other.getKubernetesVersion().equals(this.getKubernetesVersion())) {
            return false;
        }
        if (other.getLastRefreshTime() == null ^ this.getLastRefreshTime() == null) {
            return false;
        }
        if (other.getLastRefreshTime() != null && !other.getLastRefreshTime().equals(this.getLastRefreshTime())) {
            return false;
        }
        if (other.getLastTransitionTime() == null ^ this.getLastTransitionTime() == null) {
            return false;
        }
        if (other.getLastTransitionTime() != null && !other.getLastTransitionTime().equals(this.getLastTransitionTime())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getInsightStatus() == null ^ this.getInsightStatus() == null) {
            return false;
        }
        if (other.getInsightStatus() != null && !other.getInsightStatus().equals(this.getInsightStatus())) {
            return false;
        }
        if (other.getRecommendation() == null ^ this.getRecommendation() == null) {
            return false;
        }
        if (other.getRecommendation() != null && !other.getRecommendation().equals(this.getRecommendation())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getCategorySpecificSummary() == null ^ this.getCategorySpecificSummary() == null) {
            return false;
        }
        return other.getCategorySpecificSummary() == null || other.getCategorySpecificSummary().equals(this.getCategorySpecificSummary());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getKubernetesVersion() == null ? 0 : this.getKubernetesVersion().hashCode());
        hashCode = 31 * hashCode + (this.getLastRefreshTime() == null ? 0 : this.getLastRefreshTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastTransitionTime() == null ? 0 : this.getLastTransitionTime().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInsightStatus() == null ? 0 : this.getInsightStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRecommendation() == null ? 0 : this.getRecommendation().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getCategorySpecificSummary() == null ? 0 : this.getCategorySpecificSummary().hashCode());
        return hashCode;
    }

    public Insight clone() {
        try {
            return (Insight)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InsightMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

