/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.CatalogSchemaChangePolicy;
import com.amazonaws.services.glue.model.transform.S3DeltaCatalogTargetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3DeltaCatalogTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private List<List<String>> partitionKeys;
    private String table;
    private String database;
    private Map<String, String> additionalOptions;
    private CatalogSchemaChangePolicy schemaChangePolicy;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3DeltaCatalogTarget withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public S3DeltaCatalogTarget withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public S3DeltaCatalogTarget withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public List<List<String>> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(Collection<List<String>> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
            return;
        }
        this.partitionKeys = new ArrayList<List<String>>(partitionKeys);
    }

    public S3DeltaCatalogTarget withPartitionKeys(List<String> ... partitionKeys) {
        if (this.partitionKeys == null) {
            this.setPartitionKeys(new ArrayList<List<String>>(partitionKeys.length));
        }
        for (List<String> ele : partitionKeys) {
            this.partitionKeys.add(ele);
        }
        return this;
    }

    public S3DeltaCatalogTarget withPartitionKeys(Collection<List<String>> partitionKeys) {
        this.setPartitionKeys(partitionKeys);
        return this;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public S3DeltaCatalogTarget withTable(String table) {
        this.setTable(table);
        return this;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public S3DeltaCatalogTarget withDatabase(String database) {
        this.setDatabase(database);
        return this;
    }

    public Map<String, String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setAdditionalOptions(Map<String, String> additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public S3DeltaCatalogTarget withAdditionalOptions(Map<String, String> additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public S3DeltaCatalogTarget addAdditionalOptionsEntry(String key, String value) {
        if (null == this.additionalOptions) {
            this.additionalOptions = new HashMap<String, String>();
        }
        if (this.additionalOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalOptions.put(key, value);
        return this;
    }

    public S3DeltaCatalogTarget clearAdditionalOptionsEntries() {
        this.additionalOptions = null;
        return this;
    }

    public void setSchemaChangePolicy(CatalogSchemaChangePolicy schemaChangePolicy) {
        this.schemaChangePolicy = schemaChangePolicy;
    }

    public CatalogSchemaChangePolicy getSchemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public S3DeltaCatalogTarget withSchemaChangePolicy(CatalogSchemaChangePolicy schemaChangePolicy) {
        this.setSchemaChangePolicy(schemaChangePolicy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getPartitionKeys() != null) {
            sb.append("PartitionKeys: ").append(this.getPartitionKeys()).append(",");
        }
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable()).append(",");
        }
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions()).append(",");
        }
        if (this.getSchemaChangePolicy() != null) {
            sb.append("SchemaChangePolicy: ").append(this.getSchemaChangePolicy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DeltaCatalogTarget)) {
            return false;
        }
        S3DeltaCatalogTarget other = (S3DeltaCatalogTarget)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getPartitionKeys() == null ^ this.getPartitionKeys() == null) {
            return false;
        }
        if (other.getPartitionKeys() != null && !other.getPartitionKeys().equals(this.getPartitionKeys())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        if (other.getAdditionalOptions() != null && !other.getAdditionalOptions().equals(this.getAdditionalOptions())) {
            return false;
        }
        if (other.getSchemaChangePolicy() == null ^ this.getSchemaChangePolicy() == null) {
            return false;
        }
        return other.getSchemaChangePolicy() == null || other.getSchemaChangePolicy().equals(this.getSchemaChangePolicy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKeys() == null ? 0 : this.getPartitionKeys().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaChangePolicy() == null ? 0 : this.getSchemaChangePolicy().hashCode());
        return hashCode;
    }

    public S3DeltaCatalogTarget clone() {
        try {
            return (S3DeltaCatalogTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DeltaCatalogTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

