/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitystore.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.identitystore.model.AttributeOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String identityStoreId;
    private String groupId;
    private List<AttributeOperation> operations;

    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    public String getIdentityStoreId() {
        return this.identityStoreId;
    }

    public UpdateGroupRequest withIdentityStoreId(String identityStoreId) {
        this.setIdentityStoreId(identityStoreId);
        return this;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public UpdateGroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public List<AttributeOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(Collection<AttributeOperation> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        this.operations = new ArrayList<AttributeOperation>(operations);
    }

    public UpdateGroupRequest withOperations(AttributeOperation ... operations) {
        if (this.operations == null) {
            this.setOperations(new ArrayList<AttributeOperation>(operations.length));
        }
        for (AttributeOperation ele : operations) {
            this.operations.add(ele);
        }
        return this;
    }

    public UpdateGroupRequest withOperations(Collection<AttributeOperation> operations) {
        this.setOperations(operations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIdentityStoreId() != null) {
            sb.append("IdentityStoreId: ").append(this.getIdentityStoreId()).append(",");
        }
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getOperations() != null) {
            sb.append("Operations: ").append(this.getOperations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest)obj;
        if (other.getIdentityStoreId() == null ^ this.getIdentityStoreId() == null) {
            return false;
        }
        if (other.getIdentityStoreId() != null && !other.getIdentityStoreId().equals(this.getIdentityStoreId())) {
            return false;
        }
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        return other.getOperations() == null || other.getOperations().equals(this.getOperations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIdentityStoreId() == null ? 0 : this.getIdentityStoreId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        return hashCode;
    }

    public UpdateGroupRequest clone() {
        return (UpdateGroupRequest)super.clone();
    }
}

