/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.location.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.location.model.PositionalAccuracy;
import com.amazonaws.services.location.model.transform.InferredStateMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InferredState
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Double> position;
    private PositionalAccuracy accuracy;
    private Double deviationDistance;
    private Boolean proxyDetected;

    public List<Double> getPosition() {
        return this.position;
    }

    public void setPosition(Collection<Double> position) {
        if (position == null) {
            this.position = null;
            return;
        }
        this.position = new ArrayList<Double>(position);
    }

    public InferredState withPosition(Double ... position) {
        if (this.position == null) {
            this.setPosition(new ArrayList<Double>(position.length));
        }
        for (Double ele : position) {
            this.position.add(ele);
        }
        return this;
    }

    public InferredState withPosition(Collection<Double> position) {
        this.setPosition(position);
        return this;
    }

    public void setAccuracy(PositionalAccuracy accuracy) {
        this.accuracy = accuracy;
    }

    public PositionalAccuracy getAccuracy() {
        return this.accuracy;
    }

    public InferredState withAccuracy(PositionalAccuracy accuracy) {
        this.setAccuracy(accuracy);
        return this;
    }

    public void setDeviationDistance(Double deviationDistance) {
        this.deviationDistance = deviationDistance;
    }

    public Double getDeviationDistance() {
        return this.deviationDistance;
    }

    public InferredState withDeviationDistance(Double deviationDistance) {
        this.setDeviationDistance(deviationDistance);
        return this;
    }

    public void setProxyDetected(Boolean proxyDetected) {
        this.proxyDetected = proxyDetected;
    }

    public Boolean getProxyDetected() {
        return this.proxyDetected;
    }

    public InferredState withProxyDetected(Boolean proxyDetected) {
        this.setProxyDetected(proxyDetected);
        return this;
    }

    public Boolean isProxyDetected() {
        return this.proxyDetected;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPosition() != null) {
            sb.append("Position: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getAccuracy() != null) {
            sb.append("Accuracy: ").append(this.getAccuracy()).append(",");
        }
        if (this.getDeviationDistance() != null) {
            sb.append("DeviationDistance: ").append(this.getDeviationDistance()).append(",");
        }
        if (this.getProxyDetected() != null) {
            sb.append("ProxyDetected: ").append(this.getProxyDetected());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferredState)) {
            return false;
        }
        InferredState other = (InferredState)obj;
        if (other.getPosition() == null ^ this.getPosition() == null) {
            return false;
        }
        if (other.getPosition() != null && !other.getPosition().equals(this.getPosition())) {
            return false;
        }
        if (other.getAccuracy() == null ^ this.getAccuracy() == null) {
            return false;
        }
        if (other.getAccuracy() != null && !other.getAccuracy().equals(this.getAccuracy())) {
            return false;
        }
        if (other.getDeviationDistance() == null ^ this.getDeviationDistance() == null) {
            return false;
        }
        if (other.getDeviationDistance() != null && !other.getDeviationDistance().equals(this.getDeviationDistance())) {
            return false;
        }
        if (other.getProxyDetected() == null ^ this.getProxyDetected() == null) {
            return false;
        }
        return other.getProxyDetected() == null || other.getProxyDetected().equals(this.getProxyDetected());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPosition() == null ? 0 : this.getPosition().hashCode());
        hashCode = 31 * hashCode + (this.getAccuracy() == null ? 0 : this.getAccuracy().hashCode());
        hashCode = 31 * hashCode + (this.getDeviationDistance() == null ? 0 : this.getDeviationDistance().hashCode());
        hashCode = 31 * hashCode + (this.getProxyDetected() == null ? 0 : this.getProxyDetected().hashCode());
        return hashCode;
    }

    public InferredState clone() {
        try {
            return (InferredState)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InferredStateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

