/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipmentAsync;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipmentAsyncClientBuilder;
import com.amazonaws.services.lookoutequipment.AmazonLookoutEquipmentClient;
import com.amazonaws.services.lookoutequipment.model.CreateDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.CreateDatasetResult;
import com.amazonaws.services.lookoutequipment.model.CreateInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.CreateInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.CreateModelRequest;
import com.amazonaws.services.lookoutequipment.model.CreateModelResult;
import com.amazonaws.services.lookoutequipment.model.DeleteDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteDatasetResult;
import com.amazonaws.services.lookoutequipment.model.DeleteInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.DeleteModelRequest;
import com.amazonaws.services.lookoutequipment.model.DeleteModelResult;
import com.amazonaws.services.lookoutequipment.model.DescribeDataIngestionJobRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeDataIngestionJobResult;
import com.amazonaws.services.lookoutequipment.model.DescribeDatasetRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeDatasetResult;
import com.amazonaws.services.lookoutequipment.model.DescribeInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.DescribeModelRequest;
import com.amazonaws.services.lookoutequipment.model.DescribeModelResult;
import com.amazonaws.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import com.amazonaws.services.lookoutequipment.model.ListDataIngestionJobsResult;
import com.amazonaws.services.lookoutequipment.model.ListDatasetsRequest;
import com.amazonaws.services.lookoutequipment.model.ListDatasetsResult;
import com.amazonaws.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import com.amazonaws.services.lookoutequipment.model.ListInferenceExecutionsResult;
import com.amazonaws.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import com.amazonaws.services.lookoutequipment.model.ListInferenceSchedulersResult;
import com.amazonaws.services.lookoutequipment.model.ListModelsRequest;
import com.amazonaws.services.lookoutequipment.model.ListModelsResult;
import com.amazonaws.services.lookoutequipment.model.ListTagsForResourceRequest;
import com.amazonaws.services.lookoutequipment.model.ListTagsForResourceResult;
import com.amazonaws.services.lookoutequipment.model.StartDataIngestionJobRequest;
import com.amazonaws.services.lookoutequipment.model.StartDataIngestionJobResult;
import com.amazonaws.services.lookoutequipment.model.StartInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.StartInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.StopInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.StopInferenceSchedulerResult;
import com.amazonaws.services.lookoutequipment.model.TagResourceRequest;
import com.amazonaws.services.lookoutequipment.model.TagResourceResult;
import com.amazonaws.services.lookoutequipment.model.UntagResourceRequest;
import com.amazonaws.services.lookoutequipment.model.UntagResourceResult;
import com.amazonaws.services.lookoutequipment.model.UpdateInferenceSchedulerRequest;
import com.amazonaws.services.lookoutequipment.model.UpdateInferenceSchedulerResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonLookoutEquipmentAsyncClient
extends AmazonLookoutEquipmentClient
implements AmazonLookoutEquipmentAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonLookoutEquipmentAsyncClientBuilder asyncBuilder() {
        return AmazonLookoutEquipmentAsyncClientBuilder.standard();
    }

    AmazonLookoutEquipmentAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonLookoutEquipmentAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetAsync(request, null);
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request, final AsyncHandler<CreateDatasetRequest, CreateDatasetResult> asyncHandler) {
        final CreateDatasetRequest finalRequest = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetResult>(){

            @Override
            public CreateDatasetResult call() throws Exception {
                CreateDatasetResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeCreateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInferenceSchedulerResult> createInferenceSchedulerAsync(CreateInferenceSchedulerRequest request) {
        return this.createInferenceSchedulerAsync(request, null);
    }

    @Override
    public Future<CreateInferenceSchedulerResult> createInferenceSchedulerAsync(CreateInferenceSchedulerRequest request, final AsyncHandler<CreateInferenceSchedulerRequest, CreateInferenceSchedulerResult> asyncHandler) {
        final CreateInferenceSchedulerRequest finalRequest = (CreateInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateInferenceSchedulerResult>(){

            @Override
            public CreateInferenceSchedulerResult call() throws Exception {
                CreateInferenceSchedulerResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeCreateInferenceScheduler(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateModelResult> createModelAsync(CreateModelRequest request) {
        return this.createModelAsync(request, null);
    }

    @Override
    public Future<CreateModelResult> createModelAsync(CreateModelRequest request, final AsyncHandler<CreateModelRequest, CreateModelResult> asyncHandler) {
        final CreateModelRequest finalRequest = (CreateModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateModelResult>(){

            @Override
            public CreateModelResult call() throws Exception {
                CreateModelResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeCreateModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        final DeleteDatasetRequest finalRequest = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDeleteDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInferenceSchedulerResult> deleteInferenceSchedulerAsync(DeleteInferenceSchedulerRequest request) {
        return this.deleteInferenceSchedulerAsync(request, null);
    }

    @Override
    public Future<DeleteInferenceSchedulerResult> deleteInferenceSchedulerAsync(DeleteInferenceSchedulerRequest request, final AsyncHandler<DeleteInferenceSchedulerRequest, DeleteInferenceSchedulerResult> asyncHandler) {
        final DeleteInferenceSchedulerRequest finalRequest = (DeleteInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteInferenceSchedulerResult>(){

            @Override
            public DeleteInferenceSchedulerResult call() throws Exception {
                DeleteInferenceSchedulerResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDeleteInferenceScheduler(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteModelResult> deleteModelAsync(DeleteModelRequest request) {
        return this.deleteModelAsync(request, null);
    }

    @Override
    public Future<DeleteModelResult> deleteModelAsync(DeleteModelRequest request, final AsyncHandler<DeleteModelRequest, DeleteModelResult> asyncHandler) {
        final DeleteModelRequest finalRequest = (DeleteModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteModelResult>(){

            @Override
            public DeleteModelResult call() throws Exception {
                DeleteModelResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDeleteModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataIngestionJobResult> describeDataIngestionJobAsync(DescribeDataIngestionJobRequest request) {
        return this.describeDataIngestionJobAsync(request, null);
    }

    @Override
    public Future<DescribeDataIngestionJobResult> describeDataIngestionJobAsync(DescribeDataIngestionJobRequest request, final AsyncHandler<DescribeDataIngestionJobRequest, DescribeDataIngestionJobResult> asyncHandler) {
        final DescribeDataIngestionJobRequest finalRequest = (DescribeDataIngestionJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDataIngestionJobResult>(){

            @Override
            public DescribeDataIngestionJobResult call() throws Exception {
                DescribeDataIngestionJobResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDescribeDataIngestionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request) {
        return this.describeDatasetAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) {
        final DescribeDatasetRequest finalRequest = (DescribeDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDescribeDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInferenceSchedulerResult> describeInferenceSchedulerAsync(DescribeInferenceSchedulerRequest request) {
        return this.describeInferenceSchedulerAsync(request, null);
    }

    @Override
    public Future<DescribeInferenceSchedulerResult> describeInferenceSchedulerAsync(DescribeInferenceSchedulerRequest request, final AsyncHandler<DescribeInferenceSchedulerRequest, DescribeInferenceSchedulerResult> asyncHandler) {
        final DescribeInferenceSchedulerRequest finalRequest = (DescribeInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeInferenceSchedulerResult>(){

            @Override
            public DescribeInferenceSchedulerResult call() throws Exception {
                DescribeInferenceSchedulerResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDescribeInferenceScheduler(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeModelResult> describeModelAsync(DescribeModelRequest request) {
        return this.describeModelAsync(request, null);
    }

    @Override
    public Future<DescribeModelResult> describeModelAsync(DescribeModelRequest request, final AsyncHandler<DescribeModelRequest, DescribeModelResult> asyncHandler) {
        final DescribeModelRequest finalRequest = (DescribeModelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeModelResult>(){

            @Override
            public DescribeModelResult call() throws Exception {
                DescribeModelResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeDescribeModel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDataIngestionJobsResult> listDataIngestionJobsAsync(ListDataIngestionJobsRequest request) {
        return this.listDataIngestionJobsAsync(request, null);
    }

    @Override
    public Future<ListDataIngestionJobsResult> listDataIngestionJobsAsync(ListDataIngestionJobsRequest request, final AsyncHandler<ListDataIngestionJobsRequest, ListDataIngestionJobsResult> asyncHandler) {
        final ListDataIngestionJobsRequest finalRequest = (ListDataIngestionJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDataIngestionJobsResult>(){

            @Override
            public ListDataIngestionJobsResult call() throws Exception {
                ListDataIngestionJobsResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeListDataIngestionJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        final ListDatasetsRequest finalRequest = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeListDatasets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInferenceExecutionsResult> listInferenceExecutionsAsync(ListInferenceExecutionsRequest request) {
        return this.listInferenceExecutionsAsync(request, null);
    }

    @Override
    public Future<ListInferenceExecutionsResult> listInferenceExecutionsAsync(ListInferenceExecutionsRequest request, final AsyncHandler<ListInferenceExecutionsRequest, ListInferenceExecutionsResult> asyncHandler) {
        final ListInferenceExecutionsRequest finalRequest = (ListInferenceExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInferenceExecutionsResult>(){

            @Override
            public ListInferenceExecutionsResult call() throws Exception {
                ListInferenceExecutionsResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeListInferenceExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInferenceSchedulersResult> listInferenceSchedulersAsync(ListInferenceSchedulersRequest request) {
        return this.listInferenceSchedulersAsync(request, null);
    }

    @Override
    public Future<ListInferenceSchedulersResult> listInferenceSchedulersAsync(ListInferenceSchedulersRequest request, final AsyncHandler<ListInferenceSchedulersRequest, ListInferenceSchedulersResult> asyncHandler) {
        final ListInferenceSchedulersRequest finalRequest = (ListInferenceSchedulersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInferenceSchedulersResult>(){

            @Override
            public ListInferenceSchedulersResult call() throws Exception {
                ListInferenceSchedulersResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeListInferenceSchedulers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListModelsResult> listModelsAsync(ListModelsRequest request) {
        return this.listModelsAsync(request, null);
    }

    @Override
    public Future<ListModelsResult> listModelsAsync(ListModelsRequest request, final AsyncHandler<ListModelsRequest, ListModelsResult> asyncHandler) {
        final ListModelsRequest finalRequest = (ListModelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListModelsResult>(){

            @Override
            public ListModelsResult call() throws Exception {
                ListModelsResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeListModels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDataIngestionJobResult> startDataIngestionJobAsync(StartDataIngestionJobRequest request) {
        return this.startDataIngestionJobAsync(request, null);
    }

    @Override
    public Future<StartDataIngestionJobResult> startDataIngestionJobAsync(StartDataIngestionJobRequest request, final AsyncHandler<StartDataIngestionJobRequest, StartDataIngestionJobResult> asyncHandler) {
        final StartDataIngestionJobRequest finalRequest = (StartDataIngestionJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDataIngestionJobResult>(){

            @Override
            public StartDataIngestionJobResult call() throws Exception {
                StartDataIngestionJobResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeStartDataIngestionJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartInferenceSchedulerResult> startInferenceSchedulerAsync(StartInferenceSchedulerRequest request) {
        return this.startInferenceSchedulerAsync(request, null);
    }

    @Override
    public Future<StartInferenceSchedulerResult> startInferenceSchedulerAsync(StartInferenceSchedulerRequest request, final AsyncHandler<StartInferenceSchedulerRequest, StartInferenceSchedulerResult> asyncHandler) {
        final StartInferenceSchedulerRequest finalRequest = (StartInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartInferenceSchedulerResult>(){

            @Override
            public StartInferenceSchedulerResult call() throws Exception {
                StartInferenceSchedulerResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeStartInferenceScheduler(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopInferenceSchedulerResult> stopInferenceSchedulerAsync(StopInferenceSchedulerRequest request) {
        return this.stopInferenceSchedulerAsync(request, null);
    }

    @Override
    public Future<StopInferenceSchedulerResult> stopInferenceSchedulerAsync(StopInferenceSchedulerRequest request, final AsyncHandler<StopInferenceSchedulerRequest, StopInferenceSchedulerResult> asyncHandler) {
        final StopInferenceSchedulerRequest finalRequest = (StopInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopInferenceSchedulerResult>(){

            @Override
            public StopInferenceSchedulerResult call() throws Exception {
                StopInferenceSchedulerResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeStopInferenceScheduler(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateInferenceSchedulerResult> updateInferenceSchedulerAsync(UpdateInferenceSchedulerRequest request) {
        return this.updateInferenceSchedulerAsync(request, null);
    }

    @Override
    public Future<UpdateInferenceSchedulerResult> updateInferenceSchedulerAsync(UpdateInferenceSchedulerRequest request, final AsyncHandler<UpdateInferenceSchedulerRequest, UpdateInferenceSchedulerResult> asyncHandler) {
        final UpdateInferenceSchedulerRequest finalRequest = (UpdateInferenceSchedulerRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateInferenceSchedulerResult>(){

            @Override
            public UpdateInferenceSchedulerResult call() throws Exception {
                UpdateInferenceSchedulerResult result = null;
                try {
                    result = AmazonLookoutEquipmentAsyncClient.this.executeUpdateInferenceScheduler(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

