/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.marketplacecatalog.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.marketplacecatalog.model.EntityRequest;

@SdkInternalApi
public class EntityRequestMarshaller {
    private static final MarshallingInfo<String> CATALOG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Catalog").build();
    private static final MarshallingInfo<String> ENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EntityId").build();
    private static final EntityRequestMarshaller instance = new EntityRequestMarshaller();

    public static EntityRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(EntityRequest entityRequest, ProtocolMarshaller protocolMarshaller) {
        if (entityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)entityRequest.getCatalog(), CATALOG_BINDING);
            protocolMarshaller.marshall((Object)entityRequest.getEntityId(), ENTITYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

