/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mwaa;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.mwaa.AmazonMWAAAsync;
import com.amazonaws.services.mwaa.AmazonMWAAAsyncClientBuilder;
import com.amazonaws.services.mwaa.AmazonMWAAClient;
import com.amazonaws.services.mwaa.model.CreateCliTokenRequest;
import com.amazonaws.services.mwaa.model.CreateCliTokenResult;
import com.amazonaws.services.mwaa.model.CreateEnvironmentRequest;
import com.amazonaws.services.mwaa.model.CreateEnvironmentResult;
import com.amazonaws.services.mwaa.model.CreateWebLoginTokenRequest;
import com.amazonaws.services.mwaa.model.CreateWebLoginTokenResult;
import com.amazonaws.services.mwaa.model.DeleteEnvironmentRequest;
import com.amazonaws.services.mwaa.model.DeleteEnvironmentResult;
import com.amazonaws.services.mwaa.model.GetEnvironmentRequest;
import com.amazonaws.services.mwaa.model.GetEnvironmentResult;
import com.amazonaws.services.mwaa.model.ListEnvironmentsRequest;
import com.amazonaws.services.mwaa.model.ListEnvironmentsResult;
import com.amazonaws.services.mwaa.model.ListTagsForResourceRequest;
import com.amazonaws.services.mwaa.model.ListTagsForResourceResult;
import com.amazonaws.services.mwaa.model.PublishMetricsRequest;
import com.amazonaws.services.mwaa.model.PublishMetricsResult;
import com.amazonaws.services.mwaa.model.TagResourceRequest;
import com.amazonaws.services.mwaa.model.TagResourceResult;
import com.amazonaws.services.mwaa.model.UntagResourceRequest;
import com.amazonaws.services.mwaa.model.UntagResourceResult;
import com.amazonaws.services.mwaa.model.UpdateEnvironmentRequest;
import com.amazonaws.services.mwaa.model.UpdateEnvironmentResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonMWAAAsyncClient
extends AmazonMWAAClient
implements AmazonMWAAAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonMWAAAsyncClientBuilder asyncBuilder() {
        return AmazonMWAAAsyncClientBuilder.standard();
    }

    AmazonMWAAAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonMWAAAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateCliTokenResult> createCliTokenAsync(CreateCliTokenRequest request) {
        return this.createCliTokenAsync(request, null);
    }

    @Override
    public Future<CreateCliTokenResult> createCliTokenAsync(CreateCliTokenRequest request, final AsyncHandler<CreateCliTokenRequest, CreateCliTokenResult> asyncHandler) {
        final CreateCliTokenRequest finalRequest = (CreateCliTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateCliTokenResult>(){

            @Override
            public CreateCliTokenResult call() throws Exception {
                CreateCliTokenResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeCreateCliToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateEnvironmentResult> createEnvironmentAsync(CreateEnvironmentRequest request) {
        return this.createEnvironmentAsync(request, null);
    }

    @Override
    public Future<CreateEnvironmentResult> createEnvironmentAsync(CreateEnvironmentRequest request, final AsyncHandler<CreateEnvironmentRequest, CreateEnvironmentResult> asyncHandler) {
        final CreateEnvironmentRequest finalRequest = (CreateEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateEnvironmentResult>(){

            @Override
            public CreateEnvironmentResult call() throws Exception {
                CreateEnvironmentResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeCreateEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWebLoginTokenResult> createWebLoginTokenAsync(CreateWebLoginTokenRequest request) {
        return this.createWebLoginTokenAsync(request, null);
    }

    @Override
    public Future<CreateWebLoginTokenResult> createWebLoginTokenAsync(CreateWebLoginTokenRequest request, final AsyncHandler<CreateWebLoginTokenRequest, CreateWebLoginTokenResult> asyncHandler) {
        final CreateWebLoginTokenRequest finalRequest = (CreateWebLoginTokenRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateWebLoginTokenResult>(){

            @Override
            public CreateWebLoginTokenResult call() throws Exception {
                CreateWebLoginTokenResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeCreateWebLoginToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request) {
        return this.deleteEnvironmentAsync(request, null);
    }

    @Override
    public Future<DeleteEnvironmentResult> deleteEnvironmentAsync(DeleteEnvironmentRequest request, final AsyncHandler<DeleteEnvironmentRequest, DeleteEnvironmentResult> asyncHandler) {
        final DeleteEnvironmentRequest finalRequest = (DeleteEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteEnvironmentResult>(){

            @Override
            public DeleteEnvironmentResult call() throws Exception {
                DeleteEnvironmentResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeDeleteEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetEnvironmentResult> getEnvironmentAsync(GetEnvironmentRequest request) {
        return this.getEnvironmentAsync(request, null);
    }

    @Override
    public Future<GetEnvironmentResult> getEnvironmentAsync(GetEnvironmentRequest request, final AsyncHandler<GetEnvironmentRequest, GetEnvironmentResult> asyncHandler) {
        final GetEnvironmentRequest finalRequest = (GetEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetEnvironmentResult>(){

            @Override
            public GetEnvironmentResult call() throws Exception {
                GetEnvironmentResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeGetEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request) {
        return this.listEnvironmentsAsync(request, null);
    }

    @Override
    public Future<ListEnvironmentsResult> listEnvironmentsAsync(ListEnvironmentsRequest request, final AsyncHandler<ListEnvironmentsRequest, ListEnvironmentsResult> asyncHandler) {
        final ListEnvironmentsRequest finalRequest = (ListEnvironmentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEnvironmentsResult>(){

            @Override
            public ListEnvironmentsResult call() throws Exception {
                ListEnvironmentsResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeListEnvironments(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PublishMetricsResult> publishMetricsAsync(PublishMetricsRequest request) {
        return this.publishMetricsAsync(request, null);
    }

    @Override
    public Future<PublishMetricsResult> publishMetricsAsync(PublishMetricsRequest request, final AsyncHandler<PublishMetricsRequest, PublishMetricsResult> asyncHandler) {
        final PublishMetricsRequest finalRequest = (PublishMetricsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PublishMetricsResult>(){

            @Override
            public PublishMetricsResult call() throws Exception {
                PublishMetricsResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executePublishMetrics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request) {
        return this.updateEnvironmentAsync(request, null);
    }

    @Override
    public Future<UpdateEnvironmentResult> updateEnvironmentAsync(UpdateEnvironmentRequest request, final AsyncHandler<UpdateEnvironmentRequest, UpdateEnvironmentResult> asyncHandler) {
        final UpdateEnvironmentRequest finalRequest = (UpdateEnvironmentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnvironmentResult>(){

            @Override
            public UpdateEnvironmentResult call() throws Exception {
                UpdateEnvironmentResult result = null;
                try {
                    result = AmazonMWAAAsyncClient.this.executeUpdateEnvironment(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

