/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.DatasetMetadata;
import java.util.Date;

@SdkInternalApi
public class DatasetMetadataMarshaller {
    private static final MarshallingInfo<Date> CREATIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DATASETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetType").build();
    private static final MarshallingInfo<String> DATASETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<String> STATUSMESSAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessageCode").build();
    private static final DatasetMetadataMarshaller instance = new DatasetMetadataMarshaller();

    public static DatasetMetadataMarshaller getInstance() {
        return instance;
    }

    public void marshall(DatasetMetadata datasetMetadata, ProtocolMarshaller protocolMarshaller) {
        if (datasetMetadata == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)datasetMetadata.getCreationTimestamp(), CREATIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getDatasetType(), DATASETTYPE_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getDatasetArn(), DATASETARN_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getStatusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)datasetMetadata.getStatusMessageCode(), STATUSMESSAGECODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

