/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.Placement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportInstanceLaunchSpecification
implements Serializable {
    private String architecture;
    private List<String> securityGroups;
    private String additionalInfo;
    private String userData;
    private String instanceType;
    private Placement placement;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private Boolean monitoring;
    private String subnetId;
    private Boolean disableApiTermination;
    private String instanceInitiatedShutdownBehavior;
    private String privateIpAddress;

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public ImportInstanceLaunchSpecification withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public ImportInstanceLaunchSpecification withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<String>(securityGroups.length));
        }
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public ImportInstanceLaunchSpecification withSecurityGroups(Collection<String> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ArrayList<String> securityGroupsCopy = new ArrayList<String>(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public ImportInstanceLaunchSpecification withAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public ImportInstanceLaunchSpecification withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public ImportInstanceLaunchSpecification withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
    }

    public ImportInstanceLaunchSpecification withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public ImportInstanceLaunchSpecification withPlacement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public ImportInstanceLaunchSpecification withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public ImportInstanceLaunchSpecification withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public Boolean isMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
    }

    public ImportInstanceLaunchSpecification withMonitoring(Boolean monitoring) {
        this.monitoring = monitoring;
        return this;
    }

    public Boolean getMonitoring() {
        return this.monitoring;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public ImportInstanceLaunchSpecification withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public Boolean isDisableApiTermination() {
        return this.disableApiTermination;
    }

    public void setDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
    }

    public ImportInstanceLaunchSpecification withDisableApiTermination(Boolean disableApiTermination) {
        this.disableApiTermination = disableApiTermination;
        return this;
    }

    public Boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
    }

    public ImportInstanceLaunchSpecification withInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
        this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        return this;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public ImportInstanceLaunchSpecification withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArchitecture() != null) {
            sb.append("Architecture: " + this.getArchitecture() + ", ");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups() + ", ");
        }
        if (this.getAdditionalInfo() != null) {
            sb.append("AdditionalInfo: " + this.getAdditionalInfo() + ", ");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: " + this.getUserData() + ", ");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ", ");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: " + this.getPlacement() + ", ");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: " + this.getBlockDeviceMappings() + ", ");
        }
        if (this.isMonitoring() != null) {
            sb.append("Monitoring: " + this.isMonitoring() + ", ");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ", ");
        }
        if (this.isDisableApiTermination() != null) {
            sb.append("DisableApiTermination: " + this.isDisableApiTermination() + ", ");
        }
        if (this.getInstanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: " + this.getInstanceInitiatedShutdownBehavior() + ", ");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: " + this.getPrivateIpAddress() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : ((Object)this.getSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInfo() == null ? 0 : this.getAdditionalInfo().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : ((Object)this.getBlockDeviceMappings()).hashCode());
        hashCode = 31 * hashCode + (this.isMonitoring() == null ? 0 : this.isMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.isDisableApiTermination() == null ? 0 : this.isDisableApiTermination().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInitiatedShutdownBehavior() == null ? 0 : this.getInstanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification)obj;
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !((Object)other.getSecurityGroups()).equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getAdditionalInfo() == null ^ this.getAdditionalInfo() == null) {
            return false;
        }
        if (other.getAdditionalInfo() != null && !other.getAdditionalInfo().equals(this.getAdditionalInfo())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !((Object)other.getBlockDeviceMappings()).equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.isMonitoring() == null ^ this.isMonitoring() == null) {
            return false;
        }
        if (other.isMonitoring() != null && !other.isMonitoring().equals(this.isMonitoring())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.isDisableApiTermination() == null ^ this.isDisableApiTermination() == null) {
            return false;
        }
        if (other.isDisableApiTermination() != null && !other.isDisableApiTermination().equals(this.isDisableApiTermination())) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() == null ^ this.getInstanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.getInstanceInitiatedShutdownBehavior() != null && !other.getInstanceInitiatedShutdownBehavior().equals(this.getInstanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        return other.getPrivateIpAddress() == null || other.getPrivateIpAddress().equals(this.getPrivateIpAddress());
    }
}

