/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.services.elasticache.model.Subnet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheSubnetGroup
implements Serializable {
    private String cacheSubnetGroupName;
    private String cacheSubnetGroupDescription;
    private String vpcId;
    private List<Subnet> subnets;

    public String getCacheSubnetGroupName() {
        return this.cacheSubnetGroupName;
    }

    public void setCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
    }

    public CacheSubnetGroup withCacheSubnetGroupName(String cacheSubnetGroupName) {
        this.cacheSubnetGroupName = cacheSubnetGroupName;
        return this;
    }

    public String getCacheSubnetGroupDescription() {
        return this.cacheSubnetGroupDescription;
    }

    public void setCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
        this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
    }

    public CacheSubnetGroup withCacheSubnetGroupDescription(String cacheSubnetGroupDescription) {
        this.cacheSubnetGroupDescription = cacheSubnetGroupDescription;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public CacheSubnetGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<Subnet> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ArrayList<Subnet>();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ArrayList<Subnet> subnetsCopy = new ArrayList<Subnet>(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public CacheSubnetGroup withSubnets(Subnet ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<Subnet>(subnets.length));
        }
        for (Subnet value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public CacheSubnetGroup withSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ArrayList<Subnet> subnetsCopy = new ArrayList<Subnet>(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheSubnetGroupName() != null) {
            sb.append("CacheSubnetGroupName: " + this.getCacheSubnetGroupName() + ", ");
        }
        if (this.getCacheSubnetGroupDescription() != null) {
            sb.append("CacheSubnetGroupDescription: " + this.getCacheSubnetGroupDescription() + ", ");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ", ");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupName() == null ? 0 : this.getCacheSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCacheSubnetGroupDescription() == null ? 0 : this.getCacheSubnetGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : ((Object)this.getSubnets()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CacheSubnetGroup)) {
            return false;
        }
        CacheSubnetGroup other = (CacheSubnetGroup)obj;
        if (other.getCacheSubnetGroupName() == null ^ this.getCacheSubnetGroupName() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupName() != null && !other.getCacheSubnetGroupName().equals(this.getCacheSubnetGroupName())) {
            return false;
        }
        if (other.getCacheSubnetGroupDescription() == null ^ this.getCacheSubnetGroupDescription() == null) {
            return false;
        }
        if (other.getCacheSubnetGroupDescription() != null && !other.getCacheSubnetGroupDescription().equals(this.getCacheSubnetGroupDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        return other.getSubnets() == null || ((Object)other.getSubnets()).equals(this.getSubnets());
    }
}

