/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebootCacheClusterRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cacheClusterId;
    private List<String> cacheNodeIdsToReboot;

    public RebootCacheClusterRequest() {
    }

    public RebootCacheClusterRequest(String cacheClusterId, List<String> cacheNodeIdsToReboot) {
        this.cacheClusterId = cacheClusterId;
        this.cacheNodeIdsToReboot = cacheNodeIdsToReboot;
    }

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public RebootCacheClusterRequest withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public List<String> getCacheNodeIdsToReboot() {
        if (this.cacheNodeIdsToReboot == null) {
            this.cacheNodeIdsToReboot = new ArrayList<String>();
        }
        return this.cacheNodeIdsToReboot;
    }

    public void setCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
        if (cacheNodeIdsToReboot == null) {
            this.cacheNodeIdsToReboot = null;
            return;
        }
        ArrayList<String> cacheNodeIdsToRebootCopy = new ArrayList<String>(cacheNodeIdsToReboot.size());
        cacheNodeIdsToRebootCopy.addAll(cacheNodeIdsToReboot);
        this.cacheNodeIdsToReboot = cacheNodeIdsToRebootCopy;
    }

    public RebootCacheClusterRequest withCacheNodeIdsToReboot(String ... cacheNodeIdsToReboot) {
        if (this.getCacheNodeIdsToReboot() == null) {
            this.setCacheNodeIdsToReboot(new ArrayList<String>(cacheNodeIdsToReboot.length));
        }
        for (String value : cacheNodeIdsToReboot) {
            this.getCacheNodeIdsToReboot().add(value);
        }
        return this;
    }

    public RebootCacheClusterRequest withCacheNodeIdsToReboot(Collection<String> cacheNodeIdsToReboot) {
        if (cacheNodeIdsToReboot == null) {
            this.cacheNodeIdsToReboot = null;
        } else {
            ArrayList<String> cacheNodeIdsToRebootCopy = new ArrayList<String>(cacheNodeIdsToReboot.size());
            cacheNodeIdsToRebootCopy.addAll(cacheNodeIdsToReboot);
            this.cacheNodeIdsToReboot = cacheNodeIdsToRebootCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheClusterId() != null) {
            sb.append("CacheClusterId: " + this.getCacheClusterId() + ", ");
        }
        if (this.getCacheNodeIdsToReboot() != null) {
            sb.append("CacheNodeIdsToReboot: " + this.getCacheNodeIdsToReboot() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheClusterId() == null ? 0 : this.getCacheClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getCacheNodeIdsToReboot() == null ? 0 : ((Object)this.getCacheNodeIdsToReboot()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootCacheClusterRequest)) {
            return false;
        }
        RebootCacheClusterRequest other = (RebootCacheClusterRequest)obj;
        if (other.getCacheClusterId() == null ^ this.getCacheClusterId() == null) {
            return false;
        }
        if (other.getCacheClusterId() != null && !other.getCacheClusterId().equals(this.getCacheClusterId())) {
            return false;
        }
        if (other.getCacheNodeIdsToReboot() == null ^ this.getCacheNodeIdsToReboot() == null) {
            return false;
        }
        return other.getCacheNodeIdsToReboot() == null || ((Object)other.getCacheNodeIdsToReboot()).equals(this.getCacheNodeIdsToReboot());
    }
}

