/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpApiV2ProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.SecurityContext;

public class AwsHttpApiV2HttpServletRequestReader
extends RequestReader<HttpApiV2ProxyRequest, HttpServletRequest> {
    static final String INVALID_REQUEST_ERROR = "The incoming event is not a valid HTTP API v2 proxy request";

    @Override
    public HttpServletRequest readRequest(HttpApiV2ProxyRequest request, SecurityContext securityContext, Context lambdaContext, ContainerConfig config) throws InvalidRequestEventException {
        if (request.getRequestContext() == null || request.getRequestContext().getHttp().getMethod() == null || request.getRequestContext().getHttp().getMethod().equals("")) {
            throw new InvalidRequestEventException(INVALID_REQUEST_ERROR);
        }
        request.setRawPath(this.stripBasePath(request.getRawPath(), config));
        AwsHttpApiV2ProxyHttpServletRequest servletRequest = new AwsHttpApiV2ProxyHttpServletRequest(request, lambdaContext, securityContext, config);
        servletRequest.setAttribute("com.amazonaws.httpapi.request.context", request.getRequestContext());
        servletRequest.setAttribute("com.amazonaws.httpapi.stage.variables", request.getStageVariables());
        servletRequest.setAttribute("com.amazonaws.httpapi.request", request);
        servletRequest.setAttribute("com.amazonaws.lambda.context", lambdaContext);
        servletRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", securityContext);
        return servletRequest;
    }

    @Override
    protected Class<? extends HttpApiV2ProxyRequest> getRequestClass() {
        return HttpApiV2ProxyRequest.class;
    }
}

