/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.Headers;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsHttpServletResponse
implements HttpServletResponse {
    static final String HEADER_DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss z";
    static final String COOKIE_DEFAULT_TIME_ZONE = "GMT";
    private Headers headers = new Headers();
    private int statusCode;
    private String statusMessage;
    private String responseBody;
    private String characterEncoding;
    private PrintWriter writer;
    private ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
    private CountDownLatch writersCountDownLatch;
    private HttpServletRequest request;
    private boolean isCommitted = false;
    private Logger log = LoggerFactory.getLogger(AwsHttpServletResponse.class);

    public AwsHttpServletResponse(HttpServletRequest req, CountDownLatch latch) {
        this.writersCountDownLatch = latch;
        this.characterEncoding = null;
        this.request = req;
        this.statusCode = 0;
    }

    @SuppressFBWarnings(value={"COOKIE_USAGE"})
    public void addCookie(Cookie cookie) {
        if (this.request != null && this.request.getDispatcherType() == DispatcherType.INCLUDE && this.isCommitted()) {
            throw new IllegalStateException("Cannot add Cookies for include request when response is committed");
        }
        String cookieData = cookie.getName() + "=" + cookie.getValue();
        if (cookie.getPath() != null) {
            cookieData = cookieData + "; Path=" + cookie.getPath();
        }
        if (cookie.getSecure()) {
            cookieData = cookieData + "; Secure";
        }
        if (cookie.isHttpOnly()) {
            cookieData = cookieData + "; HttpOnly";
        }
        if (cookie.getDomain() != null && !"".equals(cookie.getDomain().trim())) {
            cookieData = cookieData + "; Domain=" + cookie.getDomain();
        }
        if (cookie.getMaxAge() > 0) {
            cookieData = cookieData + "; Max-Age=" + cookie.getMaxAge();
            TimeZone gmtTimeZone = TimeZone.getTimeZone(COOKIE_DEFAULT_TIME_ZONE);
            Calendar currentTimestamp = Calendar.getInstance(gmtTimeZone);
            currentTimestamp.add(13, cookie.getMaxAge());
            SimpleDateFormat cookieDateFormatter = new SimpleDateFormat(HEADER_DATE_PATTERN);
            cookieDateFormatter.setTimeZone(gmtTimeZone);
            cookieData = cookieData + "; Expires=" + cookieDateFormatter.format(currentTimestamp.getTime());
        }
        this.setHeader("Set-Cookie", cookieData, false);
    }

    public boolean containsHeader(String s) {
        return this.headers.containsKey(s);
    }

    public String encodeURL(String s) {
        return s;
    }

    public String encodeRedirectURL(String s) {
        return s;
    }

    public void sendError(int i, String s) throws IOException {
        this.request.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", (Object)DispatcherType.ERROR);
        this.setStatus(i);
        this.flushBuffer();
    }

    public void sendError(int i) throws IOException {
        this.request.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", (Object)DispatcherType.ERROR);
        this.setStatus(i);
        this.flushBuffer();
    }

    public void sendRedirect(String s) throws IOException {
        this.setStatus(302);
        this.addHeader("Location", s);
        this.flushBuffer();
    }

    public void setDateHeader(String s, long l) {
        if (!this.canSetHeader()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(HEADER_DATE_PATTERN);
        Date responseDate = new Date();
        responseDate.setTime(l);
        this.setHeader(s, sdf.format(responseDate), true);
    }

    public void addDateHeader(String s, long l) {
        if (!this.canSetHeader()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(HEADER_DATE_PATTERN);
        Date responseDate = new Date();
        responseDate.setTime(l);
        this.setHeader(s, sdf.format(responseDate), false);
    }

    public void setHeader(String s, String s1) {
        if (!this.canSetHeader()) {
            return;
        }
        if (this.isContentTypeHeader(s)) {
            this.setContentType(s1);
        } else {
            this.setHeader(s, s1, true);
        }
    }

    private boolean isContentTypeHeader(String s) {
        return s.toLowerCase(Locale.getDefault()).equals("Content-Type".toLowerCase(Locale.getDefault()));
    }

    public void addHeader(String s, String s1) {
        if (!this.canSetHeader()) {
            return;
        }
        if (this.isContentTypeHeader(s)) {
            this.setContentType(s1);
        } else {
            this.setHeader(s, s1, false);
        }
    }

    public void setIntHeader(String s, int i) {
        if (!this.canSetHeader()) {
            return;
        }
        this.setHeader(s, "" + i, true);
    }

    public void addIntHeader(String s, int i) {
        if (!this.canSetHeader()) {
            return;
        }
        this.setHeader(s, "" + i, false);
    }

    public void setStatus(int i) {
        if (!this.canSetHeader()) {
            return;
        }
        this.statusCode = i;
    }

    public int getStatus() {
        return this.statusCode <= 0 ? 200 : this.statusCode;
    }

    public String getHeader(String s) {
        return (String)this.headers.getFirst(s);
    }

    public Collection<String> getHeaders(String s) {
        if (this.headers.get(s) == null) {
            return new ArrayList<String>();
        }
        return this.headers.get(s);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){
            private WriteListener listener;

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                if (writeListener != null) {
                    try {
                        writeListener.onWritePossible();
                    }
                    catch (IOException e) {
                        AwsHttpServletResponse.this.log.error("Output stream is not writable", (Throwable)e);
                    }
                    this.listener = writeListener;
                }
            }

            public void write(int b) throws IOException {
                block2: {
                    try {
                        AwsHttpServletResponse.this.bodyOutputStream.write(b);
                    }
                    catch (Exception e) {
                        AwsHttpServletResponse.this.log.error("Cannot write to output stream", (Throwable)e);
                        if (this.listener == null) break block2;
                        this.listener.onError((Throwable)e);
                    }
                }
            }

            public void close() throws IOException {
                super.close();
                AwsHttpServletResponse.this.flushBuffer();
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (null == this.writer) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.bodyOutputStream, StandardCharsets.UTF_8));
        }
        return this.writer;
    }

    public void setCharacterEncoding(String s) {
        if (!this.canSetHeader()) {
            return;
        }
        this.characterEncoding = s.toUpperCase(Locale.getDefault());
        if (this.headers.getFirst("Content-Type") != null) {
            this.setContentType((String)this.headers.getFirst("Content-Type"));
        }
    }

    public void setContentLength(int i) {
        if (!this.canSetHeader()) {
            return;
        }
        this.setHeader("Content-Length", "" + i, true);
    }

    public void setContentLengthLong(long l) {
        if (!this.canSetHeader()) {
            return;
        }
        this.setHeader("Content-Length", "" + l, true);
    }

    public void setContentType(String s) {
        if (!this.canSetHeader()) {
            return;
        }
        if (s == null) {
            return;
        }
        String contentType = s;
        String charEncoding = this.characterEncoding;
        if (s.contains("charset=")) {
            int charsetIndex = s.indexOf("charset=") + 8;
            int endCharsetIndex = s.indexOf(" ", charsetIndex);
            if (endCharsetIndex == -1) {
                endCharsetIndex = s.length();
            }
            charEncoding = s.substring(charsetIndex, endCharsetIndex).toUpperCase(Locale.getDefault());
            contentType = s.split(";")[0];
        }
        if (charEncoding == null) {
            this.setHeader("Content-Type", String.format("%s", contentType), true);
            return;
        }
        this.characterEncoding = charEncoding;
        this.setHeader("Content-Type", String.format("%s; charset=%s", contentType, charEncoding), true);
    }

    public void setBufferSize(int i) {
        this.bodyOutputStream = new ByteArrayOutputStream(i);
    }

    public int getBufferSize() {
        return this.bodyOutputStream.size();
    }

    public void flushBuffer() throws IOException {
        if (null != this.writer) {
            this.writer.flush();
        }
        String charset = this.characterEncoding;
        byte[] respBody = this.bodyOutputStream.toByteArray();
        if (this.headers != null && this.headers.getFirst("Content-Type") != null && ((String)this.headers.getFirst("Content-Type")).toLowerCase(Locale.getDefault()).trim().equals("application/json") && charset == null) {
            charset = "UTF-8";
        }
        if (charset == null) {
            charset = LambdaContainerHandler.getContainerConfig().getDefaultContentCharset();
        }
        this.responseBody = new String(respBody, charset);
        this.log.debug("Response buffer flushed with {} bytes, latch={}", (Object)this.responseBody.length(), (Object)this.writersCountDownLatch.getCount());
        this.isCommitted = true;
        this.writersCountDownLatch.countDown();
    }

    public void resetBuffer() {
        this.bodyOutputStream = new ByteArrayOutputStream();
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void reset() {
        this.headers = new Headers();
        this.responseBody = null;
        this.writer = null;
        this.bodyOutputStream = new ByteArrayOutputStream();
    }

    public void setLocale(Locale locale) {
        if (!this.canSetHeader()) {
            return;
        }
        this.setHeader("Content-Language", locale.getLanguage(), true);
    }

    public Locale getLocale() {
        return new Locale(this.getHeader("Content-Language"));
    }

    String getAwsResponseBodyString() {
        return this.responseBody;
    }

    byte[] getAwsResponseBodyBytes() {
        if (this.bodyOutputStream != null) {
            return this.bodyOutputStream.toByteArray();
        }
        return new byte[0];
    }

    Headers getAwsResponseHeaders() {
        return this.headers;
    }

    AwsProxyRequest getAwsProxyRequest() {
        return (AwsProxyRequest)this.request.getAttribute("com.amazonaws.apigateway.request");
    }

    private void setHeader(String key, String value, boolean overwrite) {
        if (!this.canSetHeader()) {
            return;
        }
        String encodedKey = SecurityUtils.crlf(key);
        String encodedValue = SecurityUtils.crlf(value);
        ArrayList<String> values = this.headers.get(encodedKey);
        if (values == null || overwrite) {
            values = new ArrayList<String>();
        }
        values.add(encodedValue);
        this.headers.put(encodedKey, values);
    }

    private boolean canSetHeader() {
        return this.request == null || this.request.getDispatcherType() != DispatcherType.INCLUDE;
    }
}

