/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.RequestSource;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.ws.rs.core.Response;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class AwsProxyHttpServletResponseWriter
extends ResponseWriter<AwsHttpServletResponse, AwsProxyResponse> {
    private boolean writeSingleValueHeaders;

    public AwsProxyHttpServletResponseWriter() {
        this(false);
    }

    public AwsProxyHttpServletResponseWriter(boolean singleValueHeaders) {
        this.writeSingleValueHeaders = singleValueHeaders;
    }

    @Override
    public AwsProxyResponse writeResponse(AwsHttpServletResponse containerResponse, Context lambdaContext) throws InvalidResponseObjectException {
        Timer.start("SERVLET_RESPONSE_WRITE");
        AwsProxyResponse awsProxyResponse = new AwsProxyResponse();
        if (containerResponse.getAwsResponseBodyString() != null) {
            String responseString;
            if (!this.isBinary(containerResponse.getContentType()) && this.isValidUtf8(containerResponse.getAwsResponseBodyBytes())) {
                responseString = containerResponse.getAwsResponseBodyString();
            } else {
                responseString = Base64.getEncoder().encodeToString(containerResponse.getAwsResponseBodyBytes());
                awsProxyResponse.setBase64Encoded(true);
            }
            awsProxyResponse.setBody(responseString);
        }
        awsProxyResponse.setMultiValueHeaders(containerResponse.getAwsResponseHeaders());
        if (this.writeSingleValueHeaders) {
            awsProxyResponse.setHeaders(this.toSingleValueHeaders(containerResponse.getAwsResponseHeaders()));
        }
        awsProxyResponse.setStatusCode(containerResponse.getStatus());
        Response.Status responseStatus = Response.Status.fromStatusCode((int)containerResponse.getStatus());
        if (containerResponse.getAwsProxyRequest() != null && containerResponse.getAwsProxyRequest().getRequestSource() == RequestSource.ALB && responseStatus != null) {
            awsProxyResponse.setStatusDescription(containerResponse.getStatus() + " " + responseStatus.getReasonPhrase());
        }
        Timer.stop("SERVLET_RESPONSE_WRITE");
        return awsProxyResponse;
    }

    private Map<String, String> toSingleValueHeaders(Headers h) {
        HashMap<String, String> out = new HashMap<String, String>();
        if (h == null || h.isEmpty()) {
            return out;
        }
        for (String k : h.keySet()) {
            out.put(k, (String)h.getFirst(k));
        }
        return out;
    }

    private boolean isBinary(String contentType) {
        if (contentType != null) {
            int semidx = contentType.indexOf(59);
            if (semidx >= 0) {
                return LambdaContainerHandler.getContainerConfig().isBinaryContentType(contentType.substring(0, semidx));
            }
            return LambdaContainerHandler.getContainerConfig().isBinaryContentType(contentType);
        }
        return false;
    }
}

