/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.databinding.adapters;

import android.annotation.TargetApi;
import android.databinding.BindingAdapter;
import android.databinding.BindingMethod;
import android.databinding.BindingMethods;
import android.os.Build;
import android.support.annotation.RestrictTo;
import android.widget.Switch;

/**
 * @hide
 */
@RestrictTo(RestrictTo.Scope.LIBRARY)
@BindingMethods({
        @BindingMethod(type = android.widget.Switch.class, attribute = "android:thumb", method = "setThumbDrawable"),
        @BindingMethod(type = android.widget.Switch.class, attribute = "android:track", method = "setTrackDrawable"),
})
@TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)
public class SwitchBindingAdapter {

    @BindingAdapter({"android:switchTextAppearance"})
    public static void setSwitchTextAppearance(Switch view, int value) {
        view.setSwitchTextAppearance(null, value);
    }
}
