/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.adapters;

import android.content.Context;
import android.databinding.ObservableList;
import android.support.annotation.RestrictTo;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class ObservableListAdapter<T>
extends BaseAdapter {
    private List<T> mList;
    private ObservableList.OnListChangedCallback mListChangedCallback;
    private final Context mContext;
    private final int mDropDownResourceId;
    private final int mResourceId;
    private final int mTextViewResourceId;
    private final LayoutInflater mLayoutInflater;

    public ObservableListAdapter(Context context, List<T> list, int resourceId, int dropDownResourceId, int textViewResourceId) {
        this.mContext = context;
        this.mResourceId = resourceId;
        this.mDropDownResourceId = dropDownResourceId;
        this.mTextViewResourceId = textViewResourceId;
        this.mLayoutInflater = resourceId == 0 ? null : (LayoutInflater)context.getSystemService("layout_inflater");
        this.setList(list);
    }

    public void setList(List<T> list) {
        if (this.mList == list) {
            return;
        }
        if (this.mList instanceof ObservableList) {
            ((ObservableList)this.mList).removeOnListChangedCallback(this.mListChangedCallback);
        }
        this.mList = list;
        if (this.mList instanceof ObservableList) {
            if (this.mListChangedCallback == null) {
                this.mListChangedCallback = new ObservableList.OnListChangedCallback(){

                    public void onChanged(ObservableList observableList) {
                        ObservableListAdapter.this.notifyDataSetChanged();
                    }

                    public void onItemRangeChanged(ObservableList observableList, int i, int i1) {
                        ObservableListAdapter.this.notifyDataSetChanged();
                    }

                    public void onItemRangeInserted(ObservableList observableList, int i, int i1) {
                        ObservableListAdapter.this.notifyDataSetChanged();
                    }

                    public void onItemRangeMoved(ObservableList observableList, int i, int i1, int i2) {
                        ObservableListAdapter.this.notifyDataSetChanged();
                    }

                    public void onItemRangeRemoved(ObservableList observableList, int i, int i1) {
                        ObservableListAdapter.this.notifyDataSetChanged();
                    }
                };
            }
            ((ObservableList)this.mList).addOnListChangedCallback(this.mListChangedCallback);
        }
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mList.size();
    }

    public Object getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.getViewForResource(this.mResourceId, position, convertView, parent);
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getViewForResource(this.mDropDownResourceId, position, convertView, parent);
    }

    public View getViewForResource(int resourceId, int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = resourceId == 0 ? new TextView(this.mContext) : this.mLayoutInflater.inflate(resourceId, parent, false);
        }
        TextView text = (TextView)(this.mTextViewResourceId == 0 ? convertView : convertView.findViewById(this.mTextViewResourceId));
        T item = this.mList.get(position);
        CharSequence value = item instanceof CharSequence ? (CharSequence)item : String.valueOf(item);
        text.setText(value);
        return convertView;
    }
}

