/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.CallbackWrapper;
import android.databinding.tool.LayoutBinder;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import android.databinding.tool.writer.CallbackWrapperWriter;
import android.databinding.tool.writer.ComponentWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataBinder {
    List<LayoutBinder> mLayoutBinders = new ArrayList<LayoutBinder>();
    private static final String COMPONENT_CLASS = "android.databinding.DataBindingComponent";
    private JavaFileWriter mFileWriter;
    Set<String> mClassesToBeStripped = new HashSet<String>();
    private final boolean mEnableV2;

    public DataBinder(ResourceBundle resourceBundle, boolean enableV2) {
        L.d((String)"reading resource bundle into data binder", (Object[])new Object[0]);
        this.mEnableV2 = enableV2;
        if (this.mEnableV2) {
            for (ResourceBundle.LayoutFileBundle bundle : resourceBundle.getLayoutFileBundlesInSource()) {
                try {
                    this.mLayoutBinders.add(new LayoutBinder(bundle, true));
                }
                catch (ScopedException ex) {
                    Scope.defer((ScopedException)ex);
                }
            }
        } else {
            for (Map.Entry entry : resourceBundle.getLayoutBundles().entrySet()) {
                for (ResourceBundle.LayoutFileBundle bundle : (List)entry.getValue()) {
                    try {
                        this.mLayoutBinders.add(new LayoutBinder(bundle, false));
                    }
                    catch (ScopedException ex) {
                        Scope.defer((ScopedException)ex);
                    }
                }
            }
        }
    }

    public List<LayoutBinder> getLayoutBinders() {
        return this.mLayoutBinders;
    }

    public void sealModels() {
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            layoutBinder.sealModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writerBaseClasses(boolean isLibrary) {
        Preconditions.check((!this.mEnableV2 ? 1 : 0) != 0, (String)"Should not call write base classes in v2", (Object[])new Object[0]);
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            try {
                Scope.enter((ScopeProvider)layoutBinder);
                if (!isLibrary && !layoutBinder.hasVariations()) continue;
                String className = layoutBinder.getClassName();
                String canonicalName = layoutBinder.getPackage() + "." + className;
                if (this.mClassesToBeStripped.contains(canonicalName)) continue;
                List<LayoutBinder> variations = DataBinder.getVariations(this.mLayoutBinders, canonicalName);
                L.d((String)"writing data binder base %s", (Object[])new Object[]{canonicalName});
                this.mFileWriter.writeToFile(canonicalName, layoutBinder.writeViewBinderBaseClass(isLibrary, variations));
                this.mClassesToBeStripped.add(canonicalName);
            }
            catch (ScopedException ex) {
                Scope.defer((ScopedException)ex);
            }
            finally {
                Scope.exit();
            }
        }
    }

    private static List<LayoutBinder> getVariations(List<LayoutBinder> mLayoutBinders, String canonicalName) {
        ArrayList<LayoutBinder> variations = new ArrayList<LayoutBinder>();
        for (LayoutBinder layoutBinder : mLayoutBinders) {
            String className = layoutBinder.getClassName();
            String name = layoutBinder.getPackage() + "." + className;
            if (!name.equals(canonicalName)) continue;
            variations.add(layoutBinder);
        }
        return variations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinders(int minSdk) {
        this.writeCallbackWrappers(minSdk);
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            try {
                Scope.enter((ScopeProvider)layoutBinder);
                String className = layoutBinder.getImplementationName();
                String canonicalName = layoutBinder.getPackage() + "." + className;
                L.d((String)"writing data binder %s", (Object[])new Object[]{canonicalName});
                if (!this.mEnableV2) {
                    this.mClassesToBeStripped.add(canonicalName);
                }
                this.mFileWriter.writeToFile(canonicalName, layoutBinder.writeViewBinder(minSdk));
            }
            catch (ScopedException ex) {
                Scope.defer((ScopedException)ex);
            }
            finally {
                Scope.exit();
            }
        }
    }

    private void writeCallbackWrappers(int minSdk) {
        HashMap<String, CallbackWrapper> uniqueWrappers = new HashMap<String, CallbackWrapper>();
        HashSet<String> classNames = new HashSet<String>();
        boolean callbackCounter = false;
        for (LayoutBinder binder : this.mLayoutBinders) {
            for (Map.Entry<String, CallbackWrapper> entry : binder.getModel().getCallbackWrappers().entrySet()) {
                CallbackWrapper existing = (CallbackWrapper)uniqueWrappers.get(entry.getKey());
                if (existing == null) {
                    CallbackWrapper wrapper = entry.getValue();
                    uniqueWrappers.put(entry.getKey(), wrapper);
                    String listenerName = this.makeUnique(classNames, wrapper.klass.getSimpleName());
                    String methodName = this.makeUnique(classNames, "_internalCallback" + StringUtils.capitalize((String)wrapper.method.getName()));
                    wrapper.prepare(listenerName, methodName);
                    continue;
                }
                entry.getValue().prepare(existing.getClassName(), existing.getListenerMethodName());
            }
        }
        for (CallbackWrapper wrapper : uniqueWrappers.values()) {
            String code = new CallbackWrapperWriter(wrapper).write();
            String className = wrapper.getClassName();
            String canonicalName = wrapper.getPackage() + "." + className;
            this.mFileWriter.writeToFile(canonicalName, code);
            if (this.mEnableV2) continue;
            this.mClassesToBeStripped.add(canonicalName);
        }
    }

    private String makeUnique(Set<String> existing, String wanted) {
        int cnt = 1;
        while (existing.contains(wanted)) {
            wanted = wanted + cnt;
            ++cnt;
        }
        existing.add(wanted);
        return wanted;
    }

    public void writeComponent() {
        ComponentWriter componentWriter = new ComponentWriter();
        this.mClassesToBeStripped.add(COMPONENT_CLASS);
        this.mFileWriter.writeToFile(COMPONENT_CLASS, componentWriter.createComponent());
    }

    public Set<String> getClassesToBeStripped() {
        return this.mClassesToBeStripped;
    }

    public void setFileWriter(JavaFileWriter fileWriter) {
        this.mFileWriter = fileWriter;
    }

    public JavaFileWriter getFileWriter() {
        return this.mFileWriter;
    }
}

