/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.CallbackArgExpr;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.expr.StaticIdentifierExpr;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.scopes.ScopeProvider;
import android.databinding.tool.store.Location;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CallbackExprModel
extends ExprModel {
    final ExprModel mOriginal;
    final List<CallbackArgExpr> mArguments = new ArrayList<CallbackArgExpr>();

    public CallbackExprModel(ExprModel original) {
        super(original.modulePackage, original.enableV2);
        this.mOriginal = original;
    }

    @Override
    public Map<String, String> getImports() {
        return this.mOriginal.getImports();
    }

    @Override
    public StaticIdentifierExpr addImport(String alias, String type, Location location) {
        return this.mOriginal.addImport(alias, type, location);
    }

    @Override
    public <T extends Expr> T register(T expr) {
        this.setCurrentLocationInFile(this.mOriginal.getCurrentLocationInFile());
        this.setCurrentParserContext(this.mOriginal.getCurrentParserContext());
        return super.register(expr);
    }

    @Override
    public void seal() {
        HashSet completedExprs = new HashSet();
        HashSet exprs = new HashSet();
        do {
            exprs.clear();
            exprs.addAll(this.mExprMap.values());
            exprs.removeAll(completedExprs);
            for (Expr expr : exprs) {
                expr.getResolvedType();
                expr.markAsUsedInCallback();
            }
            completedExprs.addAll(exprs);
        } while (!exprs.isEmpty());
        this.markSealed();
    }

    @Override
    public IdentifierExpr identifier(String name) {
        CallbackArgExpr arg = this.findArgByName(name);
        if (arg != null) {
            return arg;
        }
        IdentifierExpr id = new IdentifierExpr(name);
        Expr existing = (Expr)this.mExprMap.get(id.getUniqueKey());
        if (existing == null) {
            IdentifierExpr identifier = this.mOriginal.identifier(name);
            this.mExprMap.put(identifier.getUniqueKey(), identifier);
            identifier.markAsUsedInCallback();
            return identifier;
        }
        return (IdentifierExpr)existing;
    }

    private CallbackArgExpr findArgByName(String name) {
        for (CallbackArgExpr arg : this.mArguments) {
            if (!name.equals(arg.getName())) continue;
            return arg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallbackArgExpr callbackArg(String name) {
        Preconditions.checkNull((Object)this.findArgByName(name), (String)"Callback arguments must have unique names. %s is used twice or more.", (Object[])new Object[]{name});
        CallbackArgExpr id = new CallbackArgExpr(this.mArguments.size(), name);
        CallbackArgExpr added = this.register(id);
        this.mArguments.add(added);
        try {
            Scope.enter((ScopeProvider)added);
            IdentifierExpr identifierWithSameName = this.mOriginal.findIdentifier(name);
            if (identifierWithSameName != null) {
                L.w((String)"%s in the callback definition will override the variable %s (%s) in the callback scope.", (Object[])new Object[]{name, name, identifierWithSameName.getUserDefinedType()});
            }
        }
        finally {
            Scope.exit();
        }
        return added;
    }

    public int getArgCount() {
        return this.mArguments.size();
    }

    public List<CallbackArgExpr> getArguments() {
        return this.mArguments;
    }
}

