/*
 * Decompiled with CFR 0.152.
 */
package com.android.signflinger;

import com.android.apksig.SigningCertificateLineage;
import com.android.apksig.util.RunnablesExecutor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class SignedApkOptions {
    final PrivateKey privateKey;
    final List<X509Certificate> certificates;
    final RunnablesExecutor executor;
    final boolean v1Enabled;
    final boolean v2Enabled;
    final boolean v3Enabled;
    final SigningCertificateLineage v3SigningCertificateLineage;
    final boolean v4Enabled;
    final File v4Output;
    final String v1CreatedBy;
    final String v1BuiltBy;
    final boolean v1TrustManifest;
    final int minSdkVersion;
    final byte[] sdkDependencies;

    private SignedApkOptions(PrivateKey privateKey, List<X509Certificate> certificates, RunnablesExecutor executor, byte[] sdkDependencies, boolean v1Enabled, boolean v2Enabled, boolean v3Enabled, SigningCertificateLineage v3SigningCertificateLineage, boolean v4Enabled, File v4Output, String v1CreatedBy, String v1BuiltBy, boolean v1TrustManifest, int minSdkVersion) {
        this.privateKey = privateKey;
        this.certificates = certificates;
        this.executor = executor;
        this.sdkDependencies = sdkDependencies;
        this.v1Enabled = v1Enabled;
        this.v2Enabled = v2Enabled;
        this.v3Enabled = v3Enabled;
        this.v3SigningCertificateLineage = v3SigningCertificateLineage;
        this.v4Enabled = v4Enabled;
        this.v4Output = v4Output;
        this.v1CreatedBy = v1CreatedBy;
        this.v1BuiltBy = v1BuiltBy;
        this.v1TrustManifest = v1TrustManifest;
        this.minSdkVersion = minSdkVersion;
    }

    public static PrivateKey bytesToPrivateKey(String keyAlgorithm, byte[] bytes) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory;
        switch (keyAlgorithm.toUpperCase(Locale.US)) {
            case "RSA": {
                keyFactory = KeyFactory.getInstance("rsa");
                break;
            }
            case "DSA": {
                keyFactory = KeyFactory.getInstance("dsa");
                break;
            }
            case "EC": {
                keyFactory = KeyFactory.getInstance("ec");
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported key algorithm: " + keyAlgorithm);
            }
        }
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
    }

    public static List<X509Certificate> bytesToCertificateChain(byte[] bytes) throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certs = certificateFactory.generateCertificates(new ByteArrayInputStream(bytes));
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certs.size());
        for (Certificate certificate : certs) {
            result.add((X509Certificate)certificate);
        }
        return result;
    }

    public static class Builder {
        PrivateKey privateKey;
        List<X509Certificate> certificates;
        RunnablesExecutor executor;
        byte[] sdkDependencies;
        boolean v1Enabled = false;
        boolean v2Enabled = true;
        boolean v3Enabled = false;
        SigningCertificateLineage v3SigningCertificateLineage;
        boolean v4Enabled = false;
        File v4Output = null;
        String v1CreatedBy = "Signflinger";
        String v1BuiltBy = "Signflinger";
        boolean v1TrustManifest;
        int minSdkVersion;

        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder setCertificates(List<X509Certificate> certificates) {
            this.certificates = certificates;
            return this;
        }

        public Builder setExecutor(RunnablesExecutor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setSdkDependencies(byte[] sdkDependencies) {
            this.sdkDependencies = sdkDependencies;
            return this;
        }

        public Builder setV1Enabled(boolean enabled) {
            this.v1Enabled = enabled;
            return this;
        }

        public Builder setV2Enabled(boolean enabled) {
            this.v2Enabled = enabled;
            return this;
        }

        public Builder setV3Enabled(boolean enabled) {
            this.v3Enabled = enabled;
            return this;
        }

        public Builder setV3SigningCertificateLineage(SigningCertificateLineage v3SigningCertificateLineage) {
            this.v3SigningCertificateLineage = v3SigningCertificateLineage;
            return this;
        }

        public Builder setV4Enabled(boolean enabled) {
            this.v4Enabled = enabled;
            return this;
        }

        public Builder setV4Output(File output) {
            this.v4Output = output;
            return this;
        }

        public Builder setV1CreatedBy(String creator) {
            this.v1CreatedBy = creator;
            return this;
        }

        public Builder setV1BuiltBy(String builder) {
            this.v1BuiltBy = builder;
            return this;
        }

        public Builder setV1TrustManifest(boolean trust) {
            this.v1TrustManifest = trust;
            return this;
        }

        public Builder setMinSdkVersion(int minSdkVersion) {
            this.minSdkVersion = minSdkVersion;
            return this;
        }

        public SignedApkOptions build() {
            return new SignedApkOptions(this.privateKey, this.certificates, this.executor, this.sdkDependencies, this.v1Enabled, this.v2Enabled, this.v3Enabled, this.v3SigningCertificateLineage, this.v4Enabled, this.v4Output, this.v1CreatedBy, this.v1BuiltBy, this.v1TrustManifest, this.minSdkVersion);
        }
    }
}

