/*
 * Decompiled with CFR 0.152.
 */
package com.android.signflinger;

import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SigningBlockUtils {
    private static final int MAGIC_NUM_BYTES = 16;
    private static final int BLOCK_LENGTH_NUM_BYTES = 8;
    static final int SIZE_OF_BLOCK_NUM_BYTES = 8;
    static final int BLOCK_ID_NUM_BYTES = 4;
    static final int VERITY_PADDING_BLOCK_ID = 1114793335;

    public static byte[] addToSigningBlock(byte[] signingBlock, byte[] blockValue, int blockId) throws IOException {
        if (blockValue == null || blockValue.length == 0) {
            return signingBlock;
        }
        if (signingBlock == null || signingBlock.length == 0) {
            return SigningBlockUtils.createSigningBlock(blockValue, blockId);
        }
        return SigningBlockUtils.appendToSigningBlock(signingBlock, blockValue, blockId);
    }

    private static byte[] appendToSigningBlock(byte[] signingBlock, byte[] blockValue, int blockId) throws IOException {
        ArrayList<Pair<byte[], Integer>> entries = new ArrayList<Pair<byte[], Integer>>(SigningBlockUtils.extractAllSigners(DataSources.asDataSource((ByteBuffer)ByteBuffer.wrap(signingBlock))));
        entries.add((Pair<byte[], Integer>)Pair.of((Object)blockValue, (Object)blockId));
        return ApkSigningBlockUtils.generateApkSigningBlock(entries);
    }

    private static byte[] createSigningBlock(byte[] blockValue, int blockId) {
        return ApkSigningBlockUtils.generateApkSigningBlock(Arrays.asList(Pair.of((Object)blockValue, (Object)blockId)));
    }

    private static List<Pair<byte[], Integer>> extractAllSigners(DataSource signingBlock) throws IOException {
        long wholeBlockSize = signingBlock.size();
        DataSource lengthPrefixedIdValuePairsSource = signingBlock.slice(8L, wholeBlockSize - 16L - 16L);
        int lengthAndIdByteCount = 12;
        ByteBuffer lengthAndId = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<Pair<byte[], Integer>> idValuePairs = new ArrayList<Pair<byte[], Integer>>();
        int index = 0;
        while ((long)index <= lengthPrefixedIdValuePairsSource.size() - 12L) {
            lengthPrefixedIdValuePairsSource.copyTo((long)index, 12, lengthAndId);
            lengthAndId.flip();
            int blockLength = Math.toIntExact(lengthAndId.getLong());
            int id = lengthAndId.getInt();
            lengthAndId.clear();
            if (id != 1114793335) {
                int blockValueSize = blockLength - 4;
                ByteBuffer blockValue = ByteBuffer.allocate(blockValueSize);
                lengthPrefixedIdValuePairsSource.copyTo((long)(index + 8 + 4), blockValueSize, blockValue);
                idValuePairs.add((Pair<byte[], Integer>)Pair.of((Object)blockValue.array(), (Object)id));
            }
            index += blockLength + 8;
        }
        return idValuePairs;
    }

    public static ByteBuffer extractBlock(File apk, int blockId) throws IOException, ZipFormatException, ApkSigningBlockNotFoundException {
        try (RandomAccessFile file = new RandomAccessFile(apk, "r");){
            DataSource apkDataSource = DataSources.asDataSource((RandomAccessFile)file);
            ApkUtils.ApkSigningBlock signingBlockInfo = ApkUtils.findApkSigningBlock((DataSource)apkDataSource, (ApkUtils.ZipSections)ApkUtils.findZipSections((DataSource)apkDataSource));
            DataSource wholeV2Block = signingBlockInfo.getContents();
            int lengthAndIdByteCount = 12;
            DataSource signingBlock = wholeV2Block.slice(8L, wholeV2Block.size() - 8L - 16L);
            ByteBuffer lengthAndId = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
            int index = 0;
            while ((long)index <= signingBlock.size() - 12L) {
                signingBlock.copyTo((long)index, 12, lengthAndId);
                lengthAndId.flip();
                int blockLength = (int)lengthAndId.getLong();
                int id = lengthAndId.getInt();
                lengthAndId.flip();
                if (id == blockId) {
                    ByteBuffer block = ByteBuffer.allocate(blockLength - 4);
                    signingBlock.copyTo((long)(index + 12), blockLength - 4, block);
                    block.flip();
                    ByteBuffer byteBuffer = block;
                    return byteBuffer;
                }
                index += blockLength + 8;
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
    }

    private SigningBlockUtils() {
    }
}

