/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.v7.widget.TintResources;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TintContextWrapper
extends ContextWrapper {
    private static final ArrayList<WeakReference<TintContextWrapper>> sCache = new ArrayList();
    private Resources mResources;
    private final Resources.Theme mTheme = this.getResources().newTheme();

    public static Context wrap(@NonNull Context context) {
        if (TintContextWrapper.shouldWrap(context)) {
            int count = sCache.size();
            for (int i = 0; i < count; ++i) {
                TintContextWrapper wrapper;
                WeakReference<TintContextWrapper> ref = sCache.get(i);
                TintContextWrapper tintContextWrapper = wrapper = ref != null ? (TintContextWrapper)((Object)ref.get()) : null;
                if (wrapper == null || wrapper.getBaseContext() != context) continue;
                return wrapper;
            }
            TintContextWrapper wrapper = new TintContextWrapper(context);
            sCache.add(new WeakReference<TintContextWrapper>(wrapper));
            return wrapper;
        }
        return context;
    }

    private static boolean shouldWrap(@NonNull Context context) {
        if (context instanceof TintContextWrapper) {
            return false;
        }
        return !(context.getResources() instanceof TintResources);
    }

    private TintContextWrapper(@NonNull Context base) {
        super(base);
        this.mTheme.setTo(base.getTheme());
    }

    public Resources.Theme getTheme() {
        return this.mTheme;
    }

    public void setTheme(int resid) {
        this.mTheme.applyStyle(resid, true);
    }

    public Resources getResources() {
        if (this.mResources == null) {
            this.mResources = new TintResources((Context)this, super.getResources());
        }
        return this.mResources;
    }
}

