/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v7.app.AppCompatCallback;
import android.support.v7.app.AppCompatDelegateImplBase;
import android.support.v7.app.AppCompatDelegateImplV11;
import android.support.v7.app.TwilightManager;
import android.support.v7.view.SupportActionModeWrapper;
import android.util.Log;
import android.view.ActionMode;
import android.view.Window;

class AppCompatDelegateImplV14
extends AppCompatDelegateImplV11 {
    private static final String KEY_LOCAL_NIGHT_MODE = "appcompat:local_night_mode";
    private static TwilightManager sTwilightManager;
    private int mLocalNightMode = -100;
    private boolean mApplyDayNightCalled;
    private boolean mHandleNativeActionModes = true;

    AppCompatDelegateImplV14(Context context, Window window, AppCompatCallback callback) {
        super(context, window, callback);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && this.mLocalNightMode == -100) {
            this.mLocalNightMode = savedInstanceState.getInt(KEY_LOCAL_NIGHT_MODE, -100);
        }
    }

    @Override
    Window.Callback wrapWindowCallback(Window.Callback callback) {
        return new AppCompatWindowCallbackV14(callback);
    }

    @Override
    public void setHandleNativeActionModesEnabled(boolean enabled) {
        this.mHandleNativeActionModes = enabled;
    }

    @Override
    public boolean isHandleNativeActionModesEnabled() {
        return this.mHandleNativeActionModes;
    }

    @Override
    public boolean applyDayNight() {
        this.mApplyDayNightCalled = true;
        int modeToApply = this.mapNightMode(this.mLocalNightMode == -100 ? AppCompatDelegateImplV14.getDefaultNightMode() : this.mLocalNightMode);
        if (modeToApply != -1) {
            return this.updateConfigurationForNightMode(modeToApply);
        }
        return false;
    }

    @Override
    public void setLocalNightMode(int mode) {
        switch (mode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                if (this.mLocalNightMode == mode) break;
                this.mLocalNightMode = mode;
                if (!this.mApplyDayNightCalled) break;
                this.applyDayNight();
                break;
            }
            default: {
                Log.d((String)"AppCompatDelegate", (String)"setLocalNightMode() called with an unknown mode");
            }
        }
    }

    int mapNightMode(int mode) {
        switch (mode) {
            case 0: {
                return this.getTwilightManager().isNight() ? 2 : 1;
            }
            case -100: {
                return -1;
            }
        }
        return mode;
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mLocalNightMode != -100) {
            outState.putInt(KEY_LOCAL_NIGHT_MODE, this.mLocalNightMode);
        }
    }

    private boolean updateConfigurationForNightMode(int mode) {
        int newNightMode;
        Resources res = this.mContext.getResources();
        Configuration conf = res.getConfiguration();
        int currentNightMode = conf.uiMode & 0x30;
        int n = newNightMode = mode == 2 ? 32 : 16;
        if (currentNightMode != newNightMode) {
            conf.uiMode = conf.uiMode & 0xFFFFFFCF | newNightMode;
            res.updateConfiguration(conf, null);
            return true;
        }
        return false;
    }

    private TwilightManager getTwilightManager() {
        if (sTwilightManager == null) {
            sTwilightManager = new TwilightManager(this.mContext.getApplicationContext());
        }
        return sTwilightManager;
    }

    class AppCompatWindowCallbackV14
    extends AppCompatDelegateImplBase.AppCompatWindowCallbackBase {
        AppCompatWindowCallbackV14(Window.Callback callback) {
            super(AppCompatDelegateImplV14.this, callback);
        }

        @Override
        public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
            if (AppCompatDelegateImplV14.this.isHandleNativeActionModesEnabled()) {
                return this.startAsSupportActionMode(callback);
            }
            return super.onWindowStartingActionMode(callback);
        }

        final ActionMode startAsSupportActionMode(ActionMode.Callback callback) {
            SupportActionModeWrapper.CallbackWrapper callbackWrapper = new SupportActionModeWrapper.CallbackWrapper(AppCompatDelegateImplV14.this.mContext, callback);
            android.support.v7.view.ActionMode supportActionMode = AppCompatDelegateImplV14.this.startSupportActionMode(callbackWrapper);
            if (supportActionMode != null) {
                return callbackWrapper.getActionModeWrapper(supportActionMode);
            }
            return null;
        }
    }
}

