/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.support.annotation.ColorRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatColorStateListInflater;
import android.util.Log;
import android.util.TypedValue;
import org.xmlpull.v1.XmlPullParser;

class ColorStateListUtils {
    private static final String LOG_TAG = "ColorStateListUtils";
    private static final ThreadLocal<TypedValue> TL_TYPED_VALUE = new ThreadLocal();

    private ColorStateListUtils() {
    }

    static ColorStateList getColorStateList(@NonNull Context context, @ColorRes int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            return context.getColorStateList(resId);
        }
        ColorStateList csl = ColorStateListUtils.inflateColorStateList(context, resId);
        if (csl != null) {
            return csl;
        }
        return ContextCompat.getColorStateList((Context)context, (int)resId);
    }

    private static ColorStateList inflateColorStateList(Context context, int resId) {
        if (ColorStateListUtils.isColorInt(context, resId)) {
            return null;
        }
        Resources r = context.getResources();
        XmlResourceParser xml = r.getXml(resId);
        try {
            return AppCompatColorStateListInflater.createFromXml(r, (XmlPullParser)xml, context.getTheme());
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Failed to inflate ColorStateList, leaving it to the framework", (Throwable)e);
            return null;
        }
    }

    static boolean isColorInt(Context context, int resId) {
        Resources r = context.getResources();
        TypedValue value = ColorStateListUtils.getTypedValue();
        r.getValue(resId, value, true);
        return value.type >= 28 && value.type <= 31;
    }

    private static TypedValue getTypedValue() {
        TypedValue tv = TL_TYPED_VALUE.get();
        if (tv == null) {
            tv = new TypedValue();
            TL_TYPED_VALUE.set(tv);
        }
        return tv;
    }
}

