/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.app.BundleCompat;
import android.support.v4.app.NotificationBuilderWithBuilderAccessor;
import android.support.v4.app.NotificationCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.text.BidiFormatter;
import android.support.v7.app.NotificationCompatImpl21;
import android.support.v7.app.NotificationCompatImpl24;
import android.support.v7.app.NotificationCompatImplBase;
import android.support.v7.app.NotificationCompatImplJellybean;
import android.support.v7.appcompat.R;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.widget.RemoteViews;
import java.util.List;

public class NotificationCompat
extends android.support.v4.app.NotificationCompat {
    public static MediaSessionCompat.Token getMediaSession(Notification notification) {
        Bundle extras = NotificationCompat.getExtras((Notification)notification);
        if (extras != null) {
            if (Build.VERSION.SDK_INT >= 21) {
                Parcelable tokenInner = extras.getParcelable("android.mediaSession");
                if (tokenInner != null) {
                    return MediaSessionCompat.Token.fromToken((Object)tokenInner);
                }
            } else {
                IBinder tokenInner = BundleCompat.getBinder((Bundle)extras, (String)"android.mediaSession");
                if (tokenInner != null) {
                    Parcel p = Parcel.obtain();
                    p.writeStrongBinder(tokenInner);
                    p.setDataPosition(0);
                    MediaSessionCompat.Token token = (MediaSessionCompat.Token)MediaSessionCompat.Token.CREATOR.createFromParcel(p);
                    p.recycle();
                    return token;
                }
            }
        }
        return null;
    }

    @RequiresApi(value=24)
    @TargetApi(value=24)
    private static void addStyleToBuilderApi24(NotificationBuilderWithBuilderAccessor builder, NotificationCompat.Builder b) {
        if (b.mStyle instanceof DecoratedCustomViewStyle) {
            NotificationCompatImpl24.addDecoratedCustomViewStyle(builder);
        } else if (b.mStyle instanceof DecoratedMediaCustomViewStyle) {
            NotificationCompatImpl24.addDecoratedMediaCustomViewStyle(builder);
        } else if (!(b.mStyle instanceof NotificationCompat.MessagingStyle)) {
            NotificationCompat.addStyleGetContentViewLollipop(builder, b);
        }
    }

    @RequiresApi(value=21)
    @TargetApi(value=21)
    private static RemoteViews addStyleGetContentViewLollipop(NotificationBuilderWithBuilderAccessor builder, NotificationCompat.Builder b) {
        if (b.mStyle instanceof MediaStyle) {
            boolean createCustomContent;
            MediaStyle mediaStyle = (MediaStyle)b.mStyle;
            NotificationCompatImpl21.addMediaStyle(builder, mediaStyle.mActionsToShowInCompact, mediaStyle.mToken != null ? mediaStyle.mToken.getToken() : null);
            boolean hasContentView = b.getContentView() != null;
            boolean isMorL = Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT <= 23;
            boolean bl = createCustomContent = hasContentView || isMorL && b.getBigContentView() != null;
            if (b.mStyle instanceof DecoratedMediaCustomViewStyle && createCustomContent) {
                RemoteViews contentViewMedia = NotificationCompatImplBase.overrideContentViewMedia(builder, b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), b.mActions, mediaStyle.mActionsToShowInCompact, false, null, hasContentView);
                if (hasContentView) {
                    NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, contentViewMedia, b.getContentView());
                }
                NotificationCompat.setBackgroundColor(b.mContext, contentViewMedia, b.getColor());
                return contentViewMedia;
            }
            return null;
        }
        if (b.mStyle instanceof DecoratedCustomViewStyle) {
            return NotificationCompat.getDecoratedContentView(b);
        }
        return NotificationCompat.addStyleGetContentViewJellybean(builder, b);
    }

    @RequiresApi(value=16)
    @TargetApi(value=16)
    private static RemoteViews addStyleGetContentViewJellybean(NotificationBuilderWithBuilderAccessor builder, NotificationCompat.Builder b) {
        if (b.mStyle instanceof NotificationCompat.MessagingStyle) {
            NotificationCompat.addMessagingFallBackStyle((NotificationCompat.MessagingStyle)b.mStyle, builder, b);
        }
        return NotificationCompat.addStyleGetContentViewIcs(builder, b);
    }

    private static NotificationCompat.MessagingStyle.Message findLatestIncomingMessage(NotificationCompat.MessagingStyle style2) {
        List messages = style2.getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            NotificationCompat.MessagingStyle.Message m = (NotificationCompat.MessagingStyle.Message)messages.get(i);
            if (TextUtils.isEmpty((CharSequence)m.getSender())) continue;
            return m;
        }
        if (!messages.isEmpty()) {
            return (NotificationCompat.MessagingStyle.Message)messages.get(messages.size() - 1);
        }
        return null;
    }

    private static CharSequence makeMessageLine(NotificationCompat.Builder b, NotificationCompat.MessagingStyle style2, NotificationCompat.MessagingStyle.Message m) {
        BidiFormatter bidi = BidiFormatter.getInstance();
        SpannableStringBuilder sb = new SpannableStringBuilder();
        boolean afterLollipop = Build.VERSION.SDK_INT >= 21;
        int color2 = afterLollipop || Build.VERSION.SDK_INT <= 10 ? -16777216 : -1;
        CharSequence replyName = m.getSender();
        if (TextUtils.isEmpty((CharSequence)m.getSender())) {
            replyName = style2.getUserDisplayName() == null ? "" : style2.getUserDisplayName();
            color2 = afterLollipop && b.getColor() != 0 ? b.getColor() : color2;
        }
        CharSequence senderText = bidi.unicodeWrap(replyName);
        sb.append(senderText);
        sb.setSpan((Object)NotificationCompat.makeFontColorSpan(color2), sb.length() - senderText.length(), sb.length(), 33);
        CharSequence text = m.getText() == null ? "" : m.getText();
        sb.append((CharSequence)"  ").append(bidi.unicodeWrap(text));
        return sb;
    }

    private static TextAppearanceSpan makeFontColorSpan(int color2) {
        return new TextAppearanceSpan(null, 0, 0, ColorStateList.valueOf((int)color2), null);
    }

    private static void addMessagingFallBackStyle(NotificationCompat.MessagingStyle style2, NotificationBuilderWithBuilderAccessor builder, NotificationCompat.Builder b) {
        SpannableStringBuilder completeMessage = new SpannableStringBuilder();
        List messages = style2.getMessages();
        boolean showNames = style2.getConversationTitle() != null || NotificationCompat.hasMessagesWithoutSender(style2.getMessages());
        for (int i = messages.size() - 1; i >= 0; --i) {
            CharSequence line;
            NotificationCompat.MessagingStyle.Message m = (NotificationCompat.MessagingStyle.Message)messages.get(i);
            CharSequence charSequence = line = showNames ? NotificationCompat.makeMessageLine(b, style2, m) : m.getText();
            if (i != messages.size() - 1) {
                completeMessage.insert(0, (CharSequence)"\n");
            }
            completeMessage.insert(0, line);
        }
        NotificationCompatImplJellybean.addBigTextStyle(builder, (CharSequence)completeMessage);
    }

    private static boolean hasMessagesWithoutSender(List<NotificationCompat.MessagingStyle.Message> messages) {
        for (int i = messages.size() - 1; i >= 0; --i) {
            NotificationCompat.MessagingStyle.Message m = messages.get(i);
            if (m.getSender() != null) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(value=14)
    @TargetApi(value=14)
    private static RemoteViews addStyleGetContentViewIcs(NotificationBuilderWithBuilderAccessor builder, NotificationCompat.Builder b) {
        if (b.mStyle instanceof MediaStyle) {
            MediaStyle mediaStyle = (MediaStyle)b.mStyle;
            boolean isDecorated = b.mStyle instanceof DecoratedMediaCustomViewStyle && b.getContentView() != null;
            RemoteViews contentViewMedia = NotificationCompatImplBase.overrideContentViewMedia(builder, b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), b.mActions, mediaStyle.mActionsToShowInCompact, mediaStyle.mShowCancelButton, mediaStyle.mCancelButtonIntent, isDecorated);
            if (isDecorated) {
                NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, contentViewMedia, b.getContentView());
                return contentViewMedia;
            }
        } else if (b.mStyle instanceof DecoratedCustomViewStyle) {
            return NotificationCompat.getDecoratedContentView(b);
        }
        return null;
    }

    @RequiresApi(value=16)
    @TargetApi(value=16)
    private static void addBigStyleToBuilderJellybean(Notification n, NotificationCompat.Builder b) {
        if (b.mStyle instanceof MediaStyle) {
            MediaStyle mediaStyle = (MediaStyle)b.mStyle;
            RemoteViews innerView = b.getBigContentView() != null ? b.getBigContentView() : b.getContentView();
            boolean isDecorated = b.mStyle instanceof DecoratedMediaCustomViewStyle && innerView != null;
            NotificationCompatImplBase.overrideMediaBigContentView(n, b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), 0, b.mActions, mediaStyle.mShowCancelButton, mediaStyle.mCancelButtonIntent, isDecorated);
            if (isDecorated) {
                NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, n.bigContentView, innerView);
            }
        } else if (b.mStyle instanceof DecoratedCustomViewStyle) {
            NotificationCompat.addDecoratedBigStyleToBuilderJellybean(n, b);
        }
    }

    private static RemoteViews getDecoratedContentView(NotificationCompat.Builder b) {
        if (b.getContentView() == null) {
            return null;
        }
        RemoteViews remoteViews = NotificationCompatImplBase.applyStandardTemplateWithActions(b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, b.mNotification.icon, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), b.getColor(), R.layout.notification_template_custom_big, false, null);
        NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, remoteViews, b.getContentView());
        return remoteViews;
    }

    @RequiresApi(value=16)
    @TargetApi(value=16)
    private static void addDecoratedBigStyleToBuilderJellybean(Notification n, NotificationCompat.Builder b) {
        RemoteViews innerView;
        RemoteViews bigContentView = b.getBigContentView();
        RemoteViews remoteViews = innerView = bigContentView != null ? bigContentView : b.getContentView();
        if (innerView == null) {
            return;
        }
        RemoteViews remoteViews2 = NotificationCompatImplBase.applyStandardTemplateWithActions(b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, n.icon, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), b.getColor(), R.layout.notification_template_custom_big, false, b.mActions);
        NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, remoteViews2, innerView);
        n.bigContentView = remoteViews2;
    }

    @RequiresApi(value=21)
    @TargetApi(value=21)
    private static void addDecoratedHeadsUpToBuilderLollipop(Notification n, NotificationCompat.Builder b) {
        RemoteViews innerView;
        RemoteViews headsUp = b.getHeadsUpContentView();
        RemoteViews remoteViews = innerView = headsUp != null ? headsUp : b.getContentView();
        if (headsUp == null) {
            return;
        }
        RemoteViews remoteViews2 = NotificationCompatImplBase.applyStandardTemplateWithActions(b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, n.icon, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), b.getColor(), R.layout.notification_template_custom_big, false, b.mActions);
        NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, remoteViews2, innerView);
        n.headsUpContentView = remoteViews2;
    }

    @RequiresApi(value=21)
    @TargetApi(value=21)
    private static void addBigStyleToBuilderLollipop(Notification n, NotificationCompat.Builder b) {
        RemoteViews innerView;
        RemoteViews remoteViews = innerView = b.getBigContentView() != null ? b.getBigContentView() : b.getContentView();
        if (b.mStyle instanceof DecoratedMediaCustomViewStyle && innerView != null) {
            NotificationCompatImplBase.overrideMediaBigContentView(n, b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), 0, b.mActions, false, null, true);
            NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, n.bigContentView, innerView);
            NotificationCompat.setBackgroundColor(b.mContext, n.bigContentView, b.getColor());
        } else if (b.mStyle instanceof DecoratedCustomViewStyle) {
            NotificationCompat.addDecoratedBigStyleToBuilderJellybean(n, b);
        }
    }

    private static void setBackgroundColor(Context context, RemoteViews views, int color2) {
        if (color2 == 0) {
            color2 = context.getResources().getColor(R.color.notification_material_background_media_default_color);
        }
        views.setInt(R.id.status_bar_latest_event_content, "setBackgroundColor", color2);
    }

    @RequiresApi(value=21)
    @TargetApi(value=21)
    private static void addHeadsUpToBuilderLollipop(Notification n, NotificationCompat.Builder b) {
        RemoteViews innerView;
        RemoteViews remoteViews = innerView = b.getHeadsUpContentView() != null ? b.getHeadsUpContentView() : b.getContentView();
        if (b.mStyle instanceof DecoratedMediaCustomViewStyle && innerView != null) {
            n.headsUpContentView = NotificationCompatImplBase.generateMediaBigView(b.mContext, b.mContentTitle, b.mContentText, b.mContentInfo, b.mNumber, b.mLargeIcon, b.mSubText, b.mUseChronometer, b.getWhenIfShowing(), b.getPriority(), 0, b.mActions, false, null, true);
            NotificationCompatImplBase.buildIntoRemoteViews(b.mContext, n.headsUpContentView, innerView);
            NotificationCompat.setBackgroundColor(b.mContext, n.headsUpContentView, b.getColor());
        } else if (b.mStyle instanceof DecoratedCustomViewStyle) {
            NotificationCompat.addDecoratedHeadsUpToBuilderLollipop(n, b);
        }
    }

    public static class DecoratedMediaCustomViewStyle
    extends MediaStyle {
    }

    public static class DecoratedCustomViewStyle
    extends NotificationCompat.Style {
    }

    public static class MediaStyle
    extends NotificationCompat.Style {
        int[] mActionsToShowInCompact = null;
        MediaSessionCompat.Token mToken;
        boolean mShowCancelButton;
        PendingIntent mCancelButtonIntent;

        public MediaStyle() {
        }

        public MediaStyle(NotificationCompat.Builder builder) {
            this.setBuilder(builder);
        }

        public MediaStyle setShowActionsInCompactView(int ... actions) {
            this.mActionsToShowInCompact = actions;
            return this;
        }

        public MediaStyle setMediaSession(MediaSessionCompat.Token token) {
            this.mToken = token;
            return this;
        }

        public MediaStyle setShowCancelButton(boolean show) {
            this.mShowCancelButton = show;
            return this;
        }

        public MediaStyle setCancelButtonIntent(PendingIntent pendingIntent) {
            this.mCancelButtonIntent = pendingIntent;
            return this;
        }
    }

    private static class Api24Extender
    extends NotificationCompat.BuilderExtender {
        private Api24Extender() {
        }

        public Notification build(NotificationCompat.Builder b, NotificationBuilderWithBuilderAccessor builder) {
            NotificationCompat.addStyleToBuilderApi24(builder, b);
            return builder.build();
        }
    }

    private static class LollipopExtender
    extends NotificationCompat.BuilderExtender {
        LollipopExtender() {
        }

        public Notification build(NotificationCompat.Builder b, NotificationBuilderWithBuilderAccessor builder) {
            RemoteViews contentView = NotificationCompat.addStyleGetContentViewLollipop(builder, b);
            Notification n = builder.build();
            if (contentView != null) {
                n.contentView = contentView;
            }
            NotificationCompat.addBigStyleToBuilderLollipop(n, b);
            NotificationCompat.addHeadsUpToBuilderLollipop(n, b);
            return n;
        }
    }

    private static class JellybeanExtender
    extends NotificationCompat.BuilderExtender {
        JellybeanExtender() {
        }

        public Notification build(NotificationCompat.Builder b, NotificationBuilderWithBuilderAccessor builder) {
            RemoteViews contentView = NotificationCompat.addStyleGetContentViewJellybean(builder, b);
            Notification n = builder.build();
            if (contentView != null) {
                n.contentView = contentView;
            }
            NotificationCompat.addBigStyleToBuilderJellybean(n, b);
            return n;
        }
    }

    private static class IceCreamSandwichExtender
    extends NotificationCompat.BuilderExtender {
        IceCreamSandwichExtender() {
        }

        public Notification build(NotificationCompat.Builder b, NotificationBuilderWithBuilderAccessor builder) {
            RemoteViews contentView = NotificationCompat.addStyleGetContentViewIcs(builder, b);
            Notification n = builder.build();
            if (contentView != null) {
                n.contentView = contentView;
            } else if (b.getContentView() != null) {
                n.contentView = b.getContentView();
            }
            return n;
        }
    }

    public static class Builder
    extends NotificationCompat.Builder {
        public Builder(Context context) {
            super(context);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        protected CharSequence resolveText() {
            if (this.mStyle instanceof NotificationCompat.MessagingStyle) {
                NotificationCompat.MessagingStyle style2 = (NotificationCompat.MessagingStyle)this.mStyle;
                NotificationCompat.MessagingStyle.Message m = NotificationCompat.findLatestIncomingMessage(style2);
                CharSequence conversationTitle = style2.getConversationTitle();
                if (m != null) {
                    return conversationTitle != null ? NotificationCompat.makeMessageLine(this, style2, m) : m.getText();
                }
            }
            return super.resolveText();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        protected CharSequence resolveTitle() {
            if (this.mStyle instanceof NotificationCompat.MessagingStyle) {
                NotificationCompat.MessagingStyle style2 = (NotificationCompat.MessagingStyle)this.mStyle;
                NotificationCompat.MessagingStyle.Message m = NotificationCompat.findLatestIncomingMessage(style2);
                CharSequence conversationTitle = style2.getConversationTitle();
                if (conversationTitle != null || m != null) {
                    return conversationTitle != null ? conversationTitle : m.getSender();
                }
            }
            return super.resolveTitle();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        protected NotificationCompat.BuilderExtender getExtender() {
            if (Build.VERSION.SDK_INT >= 24) {
                return new Api24Extender();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                return new LollipopExtender();
            }
            if (Build.VERSION.SDK_INT >= 16) {
                return new JellybeanExtender();
            }
            if (Build.VERSION.SDK_INT >= 14) {
                return new IceCreamSandwichExtender();
            }
            return super.getExtender();
        }
    }
}

